/* $Id: cinfolib.c,v 1.23 1995/08/11 12:39:30 sandro Exp $ */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "misc.h"
#include "cinfolib.h"

#if 0
#define COMPACT_SEPARATOR '$'
#else
#define COMPACT_SEPARATOR '\1'
#endif

char *
cinfo_compact_info (char *output, char *i1, char *i2, char *i3, char *i4)
{
    char *p = output;
    int num = 1;
    if (i2 != NULL)
	num++;
    if (i3 != NULL)
	num++;
    if (i4 != NULL)
	num++;
#if 0
    *p++ = num + '0';
#else
    *p++ = num;
#endif

    while (*i1)
	*p++ = *i1++;

    if (num > 1)
    {	
	*p++ = COMPACT_SEPARATOR;
	while (*i2)
	    *p++ = *i2++;

	if (num > 2)
	{
	    *p++ = COMPACT_SEPARATOR;
	    while (*i3)
		*p++ = *i3++;

	    if (num > 3)
	    {
		*p++ = COMPACT_SEPARATOR;
		while (*i4)
		    *p++ = *i4++;
	    }
	}
    }
    *p++ = '\0';
    return output;
}

void
cinfo_decompact_info (char *info, char *i1, char *i2, char *i3, char *i4)
{
    int level;
    char *p = info;

#if 0
    level = *p - '0';
#else
    level = *p;
#endif

    *i1 = '\0';

    if (level > 1)
	*i2 = '\0';
    if (level > 2)
	*i3 = '\0';
    if (level > 3)
	*i4 = '\0';

    while (*++p && *p != COMPACT_SEPARATOR)
	*i1++ = *p;
    *i1++ = 0;

    if (level > 1)
    {
	while (*++p && *p != COMPACT_SEPARATOR)
	    *i2++ = *p;
	*i2++ = 0;
    }

    if (level > 2)
    {
	while (*++p && *p != COMPACT_SEPARATOR)
	    *i3++ = *p;
	*i3++ = 0;
    }

    if (level > 3)
    {
	while (*++p && *p != COMPACT_SEPARATOR)
	    *i4++ = *p;
	*i4++ = 0;
    }
}

char *
cinfo_decompact_info_first (char *info, char *i1)
{
    char *p = info, *r = i1;

    *i1 = '\0';

     while (*++p && *p != COMPACT_SEPARATOR)
	*i1++ = *p;
    *i1++ = 0;

    return r;
}

struct symbol_entry *
cinfo_build_symbol_entry (char *name)
{
    struct symbol_entry *p;

    p = (struct symbol_entry *) xmalloc (sizeof (struct symbol_entry));

    p->name = (char *) xmalloc (strlen (name) + 1);
    strcpy (p->name, name);

    p->next = NULL;

    return p;
}

struct header_entry *
cinfo_build_header_entry (char *name)
{
    struct header_entry *p;

    p = (struct header_entry *) xmalloc (sizeof (struct header_entry));

    p->name = (char *) xmalloc (strlen (name) + 1);
    strcpy (p->name, name);

    p->head = NULL;
    p->next = NULL;

    return p;
}

struct library_entry *
cinfo_build_library_entry (char *name)
{
    struct library_entry *p;

    p = (struct library_entry *) xmalloc (sizeof (struct library_entry));

    p->name = (char *) xmalloc (strlen (name) + 1);
    strcpy (p->name, name);

    p->head = NULL;
    p->next = NULL;

    return p;
}

void
cinfo_free_library_entry (struct library_entry *entry)
{
    entry->next = NULL;
    entry->head = NULL;
    free (entry->name);
    entry->name = NULL;
    free (entry);
}

void
cinfo_free_header_entry (struct header_entry *entry)
{
    entry->next = NULL;
    entry->head = NULL;
    free (entry->name);
    entry->name = NULL;
    free (entry);
}

void
cinfo_free_symbol_entry (struct symbol_entry *entry)
{
    entry->next = NULL;
    free (entry->name);
    entry->name = NULL;
    free (entry);
}

struct header_entry *
cinfo_add_header_to_list (struct header_entry *list,
			  struct header_entry *entry)
{
    struct header_entry *p = list;

    while (p->next != NULL)
	p = p->next;

    p->next = entry;

    return list;
}

struct symbol_entry *
cinfo_add_symbol_to_list (struct symbol_entry *list,
			  struct symbol_entry *entry)
{
    struct symbol_entry *p = list;

    while (p->next != NULL)
	p = p->next;

    p->next = entry;

    return list;
}

struct library_entry *
cinfo_add_library_to_list (struct library_entry *list,
			   struct library_entry *entry)
{
    struct library_entry *p = list;

    while (p->next != NULL)
	p = p->next;

    p->next = entry;

    return list;
}

struct header_entry *
cinfo_search_header (struct header_entry *list, char *name)
{
    char buf[128];
    struct header_entry *p = list;

    while (p != NULL)
    {
	if (strcmp (cinfo_decompact_info_first (p->name, buf), name) == 0)
	    return p;
	p = p->next;
    }

    return NULL;
}

struct symbol_entry *
cinfo_search_symbol (struct symbol_entry *list, char *name)
{
    char buf[128];
    struct symbol_entry *p = list;

    while (p != NULL)
    {
	if (strcmp (cinfo_decompact_info_first (p->name, buf), name) == 0)
	    return p;
	p = p->next;
    }

    return NULL;
}

struct library_entry *
cinfo_search_library (struct library_entry *list, char *name)
{
    char buf[128];
    struct library_entry *p = list;

    while (p != NULL)
    {
	if (strcmp (cinfo_decompact_info_first (p->name, buf), name) == 0)
	    return p;
	p = p->next;
    }

    return NULL;
}

struct symbol_entry *
cinfo_query_symbol_list_about_symbol (struct symbol_entry *list, char *name)
{
    struct symbol_entry *p = list, *e, *r = NULL;

    while (p != NULL && (p = cinfo_search_symbol (p, name)) != NULL)
    {
	e = cinfo_build_symbol_entry (p->name);

	if (r == NULL)
	    r = e;
	else
	    cinfo_add_symbol_to_list (r, e);

	p = p->next;
    }

    return r;
}

struct symbol_entry *
cinfo_duplicate_symbol_list (struct symbol_entry *list)
{
    struct symbol_entry *p = list, *e, *r = NULL;

    while (p != NULL)
    {
	e = cinfo_build_symbol_entry (p->name);

	if (r == NULL)
	    r = e;
	else
	    cinfo_add_symbol_to_list (r, e);

	p = p->next;
    }

    return r;
}

struct header_entry *
cinfo_duplicate_header_list (struct header_entry *list)
{
    struct header_entry *p = list, *e, *r = NULL;

    while (p != NULL)
    {
	e = cinfo_build_header_entry (p->name);

	if (p->head != NULL)
	    e->head = cinfo_duplicate_symbol_list (p->head);

	if (r == NULL)
	    r = e;
	else
	    cinfo_add_header_to_list (r, e);

	p = p->next;
    }

    return r;
}

struct library_entry *
cinfo_duplicate_library_list (struct library_entry *list)
{
    struct library_entry *p = list, *e, *r = NULL;

    while (p != NULL)
    {
	e = cinfo_build_library_entry (p->name);

	if (p->head != NULL)
	    e->head = cinfo_duplicate_header_list (p->head);

	if (r == NULL)
	    r = e;
	else
	    cinfo_add_library_to_list (r, e);

	p = p->next;
    }

    return r;
}

struct header_entry *
cinfo_query_header_list_about_header (struct header_entry *list, char *name)
{
    struct header_entry *p = list, *e, *r = NULL;

    while (p != NULL && (p = cinfo_search_header (p, name)) != NULL)
    {
	e = cinfo_build_header_entry (p->name);
	e->head = cinfo_duplicate_symbol_list (p->head);

	if (r == NULL)
	    r = e;
	else
	    cinfo_add_header_to_list (r, e);

	p = p->next;
    }

    return r;
}

struct library_entry *
cinfo_query_library_list_about_library (struct library_entry *list, char *name)
{
    struct library_entry *p = list, *e, *r = NULL;

    while (p != NULL && (p = cinfo_search_library (p, name)) != NULL)
    {
	e = cinfo_build_library_entry (p->name);
	e->head = cinfo_duplicate_header_list (p->head);

	if (r == NULL)
	    r = e;
	else
	    cinfo_add_library_to_list (r, e);

	p = p->next;
    }

    return r;
}

struct header_entry *
cinfo_query_header_list_about_symbol (struct header_entry *list, char *name)
{
    struct header_entry *hp = list, *he, *r = NULL;
    struct symbol_entry *sp;

    while (hp != NULL)
    {
	sp = cinfo_query_symbol_list_about_symbol (hp->head, name);

	if (sp != NULL)
	{
	    he = cinfo_build_header_entry (hp->name);
	    he->head = sp;

	    if (r == NULL)
		r = he;
	    else
		cinfo_add_header_to_list (r, he);
	}

	hp = hp->next;
    }

    return r;
}

struct library_entry *
cinfo_query_library_list_about_header (struct library_entry *list, char *name)
{
    struct library_entry *lp = list, *le, *r = NULL;
    struct header_entry *hp;

    while (lp != NULL)
    {
	hp = cinfo_query_header_list_about_header (lp->head, name);

	if (hp != NULL)
	{
	    le = cinfo_build_library_entry (lp->name);
	    le->head = hp;

	    if (r == NULL)
		r = le;
	    else
		cinfo_add_library_to_list (r, le);
	}

	lp = lp->next;
    }

    return r;
}

struct library_entry *
cinfo_query_library_list_about_symbol (struct library_entry *list, char *name)
{
    struct library_entry *lp = list, *le, *r = NULL;
    struct header_entry *hp;

    while (lp != NULL)
    {
	hp = cinfo_query_header_list_about_symbol (lp->head, name);

	if (hp != NULL)
	{
	    le = cinfo_build_library_entry (lp->name);
	    le->head = hp;

	    if (r == NULL)
		r = le;
	    else
		cinfo_add_library_to_list (r, le);
	}

	lp = lp->next;
    }

    return r;
}

void
cinfo_explore_symbol_list (struct symbol_entry *list)
{
    struct symbol_entry *p = list;

    while (p != NULL)
    {
	printf ("    | symbol %p \"%s\" next -> %p\n",
		p, p->name, p->next);

	p = p->next;
    }
}

void
cinfo_explore_header_list (struct header_entry *list)
{
    struct header_entry *p = list;

    while (p != NULL)
    {
	printf ("  | header %p \"%s\" next -> %p symbols -> %p\n",
		p, p->name, p->next, p->head);

	if (p->head != NULL)
	    cinfo_explore_symbol_list (p->head);

	p = p->next;
    }
}

void
cinfo_explore_library_list (struct library_entry *list)
{
    struct library_entry *p = list;

    while (p != NULL)
    {
	printf ("library %p \"%s\" next -> %p headers -> %p\n",
		p, p->name, p->next, p->head);

	if (p->head != NULL)
	    cinfo_explore_header_list (p->head);

	p = p->next;
    }
}

void
cinfo_recursive_free_symbol_list (struct symbol_entry *list)
{
    struct symbol_entry *p = list, *next;

    while (p != NULL)
    {
	next = p->next;

	cinfo_free_symbol_entry (p);

	p = next;
    }
}

void
cinfo_recursive_free_header_list (struct header_entry *list)
{
    struct header_entry *p = list, *next;

    while (p != NULL)
    {
	if (p->head != NULL)
	    cinfo_recursive_free_symbol_list (p->head);

	next = p->next;

	cinfo_free_header_entry (p);

	p = next;
    }
}

void
cinfo_recursive_free_library_list (struct library_entry *list)
{
    struct library_entry *p = list, *next;

    while (p != NULL)
    {
	if (p->head != NULL)
	    cinfo_recursive_free_header_list (p->head);

	next = p->next;

	cinfo_free_library_entry (p);

	p = next;
    }
}

/*
   avrebbe dovuto essere una cosa semplice semplice...
   ...ma in poco tempo diveni' una porcheria. --S.S.
*/
