/* hash.h */

#ifndef TRUE

#define TRUE	1
#define FALSE	0

#endif

#define SZE_HASH_IDENT 	50
#define SZE_HASH_TABLE	65537	/* should be a prime value */

#define TOKEN_FOUND	 1L
#define TOKEN_NOT_FOUND	-1L

#define TOKEN_SEPARATOR	'|'	/* Separator  */

#define TOKEN_DEFD	1	/* Bit 1 */
#define TOKEN_USED	2	/* Bit 2 */
#define TOKEN_LOCAL	4	/* Bit 3 */

#ifndef __BYTE_DEFINED__

typedef unsigned char   byte;
typedef unsigned short  word;

#define __BYTE_DEFINED__   1
#endif

typedef struct {	char	ident [SZE_HASH_IDENT];	/* Token-Name */
			long	type;			/* Token-Typ */
			short	flags;			/* Flags */
			void	*data;			/* Datenspeicher */
		}	t_hash_data;

typedef struct {	char	*ident;			/* Token-Name */

			long	type;			/* Token-Typ */
			short	flags;			/* Flags */
			void	*data;			/* Datenspeicher */
		}	t_hash_table_data;

typedef t_hash_table_data t_hash_table [SZE_HASH_TABLE];

typedef char t_ident [SZE_HASH_IDENT];


/* function prototypes: */

void init_hashtable (void);
long save_hashtable (void);
long load_hashtable (void);
long hash_search_steps (void);

void set_token_flag (long index, short flag);
short get_token_flag (long index);

long search_token (char *ident, t_hash_data *data);
long insert_token (t_hash_data *data);
void update_token (t_hash_data *data, long index);
void get_token (t_hash_data *data, long index);
void clear_token (long index);
long create_token_id (void);

char *get_symbol (long index);
