/*
    c-bat.h : Browsing an Analysis Tool for C-source code;
              Global data-structures and defines for all browser modules

    Copyright (C) 1993  Eckehard Stolz

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (version 2 of the License).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define MAX_FILENAME          256  /* Maximum Filename of Source Files 
                                      (INCLUDING DIRECTORY !!!)
                                      Not maxpath because this would use
                                      up too much memory (I use a lot of
                                      static string arrays !)
                                      But who the hell uses longer file-
                                      names than 256 char's ???
                                    */

#define MAX_IDENT             256  /* Maximum Identifier-size read in  */
#define HASH_ARRAY_INIT_SIZE  100  /* Hash-Index-Array with 100 elements*/

/* commands must be smaller than 0xff because they are used to filter
   messages from server
 */
#define CMD_INIT           1 /* Initialize                         */
#define CMD_CALLS          2 /* Get functions called by target     */
#define CMD_CALLED_BY      3 /* Get functions that call target     */
#define CMD_FUNCT_POS      4 /* Get position of target-function    */
#define CMD_VAR_POS        5 /* Get position of target-variable    */
#define CMD_USES           6 /* List Var-usage in target-function  */
#define CMD_USED_BY        7 /* List function that use variable    */
#define CMD_USES_ALL       8 /* usage of all variable in function  */
#define CMD_FILE           9 /* Module, where FILE belongs to      */
#define CMD_INCLUDES      10 /* Return Include-Files of given file */
#define CMD_FUNCTIONS     11 /* Return all functions in project    */
#define CMD_VARIABLES     12 /* Return global variables in project */
#define CMD_WHAT_IS       13 /* Return all types of given symbol   */
#define CMD_INCLUDED_BY   14 /* Return files which include file    */


/* These commands work like the corresponding command above, except
   that every symbole is returned just once instead of every 
   occurence 
 */
#define CMD_CALLS_ONCE     15 /* Get functions called by target      */
#define CMD_CALLED_BY_ONCE 16 /* Get functions that call target      */
#define CMD_USES_ONCE      17 /* List Var-usage in target-function   */
#define CMD_USED_BY_ONCE   18 /* List function that use variable     */


#define CMD_STRUCTS        19 /* List structs in project             */
#define CMD_UNIONS         20 /* List unions in project              */
#define CMD_ENUMS          21 /* List enums in project               */
#define CMD_TYPEDEFS       22 /* List typedefs in project            */

#define CMD_REFERENCE      23 /* position, where component used      */
#define CMD_REFERENCE_F    24 /* component used in a function        */
#define CMD_REFERENCE_V    25 /* component and variable in same line */

#define CMD_FILES          26 /* All files in a project              */
#define CMD_WORK_DIR       27 /* Return files which include file     */
#define CMD_MACROS         28 /* Return all macro-definition         */
#define CMD_MACRO_POS      29 /* Get position of target-macro        */
#define CMD_SEND_FILE      30 /* Send File and lineno as arguments   */
#define CMD_DEF_POS        31 /* position of item (SEND_FILE first)  */

#define CMD_CONNECT      101 /* Client requests connection to server   */
#define CMD_RELEASE      102 /* Client terminates connection to server */
#define CMD_TERMINATE    103 /* Client requests termination of server  */
#define CMD_ABORT        104 /* Client aborts actual request           */
#define CMD_SERVER       105 /* Server requests ID from Master         */
#define CMD_SERVERKILL   107 /* Server releases ID in Master           */
#define CMD_SERVER_ID    108 /* Clients requests ID of matching server */
#define CMD_SERVERTABLE  109 /* old master sends table to new master   */
#define CMD_S_TABLE_END  110 /* Server-table sent completly            */
#define CMD_NEW_FILE     111 /* Server has a new browser-file          */
#define CMD_TABLE        112 /* client requests server-table           */

#define RET_FILE          501 /* Return a File and (optional) Module     */
#define RET_FUNCT         502 /* Return function-name and position       */
#define RET_VAR           503 /* Return variable-name and position       */
#define RET_L_VAR         504 /* Return local variable-name and position */
#define RET_POS           505 /* Returns Position                        */
#define RET_END           506 /* No more items found                     */
#define RET_ERROR         507 /* Error: Message send in arg1             */
#define RET_OK            508 /* CMD_INIT was successful                 */
#define RET_STRUCT        509 /* Structure-name                          */
#define RET_UNION         510 /* Union name                              */
#define RET_ENUM          511 /* Enum name                               */
#define RET_E_CONST       512 /* Enum Constant                           */
#define RET_S_COMP        513 /* Struct Component                        */
#define RET_U_COMP        514 /* Union Component                         */
#define RET_TYPEDEF       515 /* Typedef                                 */
#define RET_REFERENCE     516 /* Usage of a struct or union component    */
#define RET_FPOS          517 /* Position of a function (incl. endline)  */
#define RET_DIR           518 /* Working directory of a file             */
#define RET_MACRO         519 /* Macro definition                        */
#define RET_COMP          520 /* Struct or Union comp. (WHAT_IS)         */
#define RET_ENUM_C        521 /* Enum constant (WHAT_IS)                 */

#define RET_CONNECT       601 /* Connection established                  */
#define RET_REFUSED       602 /* Connection to server refused            */
#define RET_CMD_UNKNOWN   603 /* Command unknown to server               */
#define RET_TIMEOUT       604 /* Server did not respond                  */
#define RET_ABORT         605 /* Command aborted                         */
#define RET_PLEASE_WAIT   606 /* Server requests more time               */
#define RET_SERVER_ID     607 /* Master-Server returns server ID         */

#define SECONDS_TIMEOUT     5 /* Client waits 5 seconds (240 for debugging)   */
#define SECONDS_PATIENCE    2 /* Server sends RET_PLEASE_WAIT every 2 seconds */

#define INTRFACE_BUFSIZE  1024 /* maximum size of message */
#define STRINGSIZE        80  
#define ARGUMENT_OFFSET   12  /* 12 Byte offset, before Arguments       */
                              /* command (2) + flags (2) + pid (4) + id */

#define DEFAULT_KEY       11  /* default Key for IPC-message queue     */
#define MASTER_ID          1  /* ID of master-server.                  */

#define MAX_CLIENTS       20  /* maximum of 20 clients connected to    */
                              /* the servers at a time                 */

#define MAX_SERVERS        7  /* maximum of 7 servers                  */
#define TMP_SERVER_ID      8  /* temporary Server ID                   */

extern  int client_pid;  /* pid of client that issued actual command */

#ifdef BRS_SERVER

extern long  cmd_id;   /* Id if msg sent by client application */
extern long  ret_id;   /* Id of return-message sent by server  */

extern short get_brs_cmd(char *arg1, char *arg2);
extern void send_brs_ret( short ret_code, short flag, int pid, 
                   char * arg1, char *arg2, char *arg3, char *arg4 );
#else

extern long  cmd_id;   /* Id if msg sent by client application */
extern long  ret_id;   /* Id of return-message sent by server  */

extern short get_brs_ret(short command, int *server, short *flag, char *arg1, 
                         char *arg2, char *arg3, char *arg4);
extern void send_brs_cmd( int server, short command, short flag, 
                         char * arg1, char *arg2);

short brs_get_msg_debug(short command, int * server, int *pid, short *ret_cmd, int *ret_id, 
                    short *r_flag, char *arg1, 
                    char *arg2, char *arg3, char *arg4);
#endif

extern short brs_get_any_message(int *type, short *cmd, short *flag, 
                          int *pid, long *id, char *buf);
