/* Errors list of Checker.
   Copyright 1993,1994 Tristan Gingold
		  Written August 1993 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 The author may be reached (Email) at the address gingold@amoco.saclay.cea.fr,
 or (US/French mail) as   Tristan Gingold 
   			  8 rue Parmentier
   			  F-91120 PALAISEAU
   			  FRANCE 
*/

#include "checker.h"
#include "errlist.h"
#include <signal.h>

/* chkr_errno replace totaly errno: the syscalls use chkr_errno.  By not
 * using errno, we don't have to save it. */
int chkr_errno;

extern struct error_t {char *error; int dis;} error_type[];

/* The function to called to disable a range of address. */
int parse_disable_range (char *str);

/* Display the name of the error and the current stack frames. */
int
chkr_perror(int e)
{
 if (error_type[e].dis)
   return 0;
 chkr_header(error_type[e].error);
 chkr_printf("\n");
#ifdef CHKR_SAVESTACK
 chkr_frames_to_forget = 2;
 chkr_show_frames();
#endif  /* CHKR_SAVESTACK */
 return 1;
}

/* Abort routine */
void
chkr_abort()
{
#ifndef MDCHECKER
 /* bad bad */
  chkr_do_end();
  kill(getpid(),SIGIOT);
  _exit(250);
#else
  abort();
#endif /* MDCHECKER */
}

/* Disable errors.  STR can be a type (3 letters), an address or a range.
 *  Called by parse-args.c
 */
int
parse_disable (const char *str)
{
  struct error_t *et = error_type;
  char arg[strlen(str)];
  
  strcpy(arg, str);
  
  if (arg[0] >= 'a' && arg[0] <= 'z')
    {
      /* ARG is a type. */
      if (strlen (arg) != 3)
        return 0;			/* bad */
      while ((et->error)[0] != '\0')
        {
          if (strncmp (arg, &((et->error)[1]), 3) == 0)
	    {
	      et->dis = 1;
	      return 1;
	    }
          et++;
        }
      return 0;			/* not found */
    }
  else
#ifdef MDCHECKER
    return 0;
#else
    return parse_disable_range(arg);
#endif
}

/* Return TRUE if the error E is disable. */
int
is_error_disable(int e)
{
  return error_type[e].dis;
}

/* Display the error I if it is not disable.  Return 0 if it is disable. */
int
chkr_report(int i)
{
  if (error_type[i].dis)
    return 0;
  chkr_header(error_type[i].error);
  chkr_printf("\n");
  return 1;
}
