#include <syscall.h>

#define __KERNEL__ 
#include <sys/shm.h>

extern int chkr_errno;

static inline int
ipc (int __call, int __first, int __second, int __third, void * __ptr)
{
  long __res;
  __asm__ __volatile__ ("int $0x80"
	: "=a" (__res)
	: "0" (SYS_ipc),"b" ((long)__call),"c" ((long)__first),
	  "d" ((long)__second),"S" ((long)__third),"D" ((long)__ptr));
  if (__res >= 0)
    return (int) __res;
  chkr_errno=-__res;
  return -1;
}

int
shmctl (int shmid, int cmd, struct shmid_ds *buf)
{
    return ipc (SHMCTL, shmid, cmd, 0, buf);
}
