#include <syscall.h>
#include <sys/types.h>
#include <sys/mman.h>

extern int chkr_errno;

static inline long
_mmap(unsigned long *buffer)
{
  long __res;
  __asm__ __volatile__ ("int $0x80"
	: "=a" (__res)
	: "0" (SYS_mmap),"b" ((long)(buffer)):"bx");
  if ((__res) >= 0 || (__res) < -__MAX_ERRNO)
    return (long) __res;
  chkr_errno = -__res;
  return -1;
}

caddr_t
mmap(caddr_t addr, size_t len, int prot, int flags, int fd, off_t off)
{
	unsigned long buffer[6];

	buffer[0] = (unsigned long)addr;
	buffer[1] = (unsigned long)len;
	buffer[2] = (unsigned long)prot;
	buffer[3] = (unsigned long)flags;
	buffer[4] = (unsigned long)fd;
	buffer[5] = (unsigned long)off;
	return (caddr_t) _mmap(buffer);
}
