/****************************************************************************
** $Id: qmemchk.h,v 1.1 1995/01/11 11:54:21 hanord Exp $
**
** Definition of memory checking routines
**
** Author  : Haavard Nord
** Created : 920624
**
** Copyright (C) 1992-1995 by Troll Tech AS.  All rights reserved.
**
** --------------------------------------------------------------------------
** Define the CHECK_MEMORY flag and recompile tools to enable memory checking.
*****************************************************************************/

#ifndef QMEMCHK_H
#define QMEMCHK_H


#if !defined(QGLOBAL_H)
#include "qglobal.h"
#endif


void  memchkSetLogFile( const char * );		// default is "MEMCHK.LOG"
void  memchkSetBufSize( int );			// default is 8192
bool  memchkSetReporting( bool );		// default is TRUE

void  memchkStart();				// start memory check
void  memchkStop();				// stop checking


#if defined(CHECK_MEMORY)

void *operator new( uint size );		// replace new operator
void  operator delete( void *p );		// replace delete operator

#endif


#endif // QMEMCHK_H
