//
// Qt Sample Application: wheel.cpp
//
// Demonstrates use of colors and advanced world transformations.
//

#include <qwidget.h>
#include <qpainter.h>
#include <qapp.h>


//
// This function draws the color wheel.
// The coordinate system x=(0..500), y=(0..500) spans the paint device.
//

void drawColorWheel( QPainter *p )
{
    QFont f( "times", 18, QFont::Bold );
    p->setFont( f );
    p->setPen( black );				// black pen outline
    p->setWindow( 0, 0, 500, 500 );		// defines coordinate system

    for ( int i=0; i<36; i++ ) {		// draws 36 rotated rectangles

	Q2DMatrix matrix;
	matrix.translate( 250, 250 );		// move to center
	matrix.shear( 0.0, 0.3 );		// twist it
	matrix.rotate( i*10 );			// rotate 0,10,20,.. degrees
	p->setWorldMatrix( matrix );		// use this world matrix

	QColor c;
	c.setHSV( i*10, 255, 255 );		// rainbow effect
	p->setBrush( c );			// solid fill with color c
	p->drawRect( 70, -10, 80, 10 );		// draw the rectangle

	QString n;
	n.sprintf( "H=%d", i*10 );
	p->drawText( 80+70+5, 0, n );		// draw the hue number
    }
}


class SimpleDrawingWidget : public QWidget	// very simple widget
{
protected:
    void   paintEvent( QPaintEvent * );		// repaints widget
};


void SimpleDrawingWidget::paintEvent( QPaintEvent * )
{
    QPainter paint;
    paint.begin( this );			// begin painting
    drawColorWheel( &paint );			// draw color wheel
    paint.end();				// painting done
}


//
// Create and display our widget
//

int main( int argc, char **argv )
{
    QApplication	app( argc, argv );	// QApplication required!
    SimpleDrawingWidget simple;
    simple.setBackgroundColor( white );
    simple.show();
    return app.exec( &simple );
}
