/****************************************************************************
** $Id: qhiscore.h,v 1.1 1995/05/16 15:55:41 eiriken Exp $
**
** Definition of QHighScore class
**
** Author  : Eirik Eng
** Created : 950102
**
** Copyright (C) 1995 by Troll Tech AS.	 All rights reserved.
**
*****************************************************************************/

#ifndef HISCORE_H
#define HISCORE_H

#include "qview.h"
#include "qlist.h"
#include "qdstream.h"

struct QHighScoreInfo
{
    long    score;
    QString id;
};

declare(QListM,QHighScoreInfo);

class QHighScore : public QWidget
{
    Q_OBJECT
public:
    QHighScore( QWidget *parent=0, const char *name=0 );
    QHighScore( int nScores, QWidget *parent=0, const char *name=0 );
    ~QHighScore();

    void setNScores( int );

slots:
    bool save( QDataStream *s )
    bool load( QDataStream *s );
    void setNewScore( int score, const char * );

protected:
    resizeEvent( QResizeEvent* );

private:
    void init();

    QListBox *lBox;
    int nSc;
    QListM(QHighScoreInfo) scores;
};

#endif
