// $Id: qmag.h,v 1.1 1995/06/28 14:45:54 agulbra Exp $
#include <qwidget.h>
#include <qcombo.h>
#include <qpixmap.h>

class MagWidget : public QWidget {
    Q_OBJECT
public:
    MagWidget( QWidget *parent=0, const char *name=0 );

public slots:
    void setZoom( int );
    void setRefresh( int );

protected:
    void paintEvent( QPaintEvent * );
    void mousePressEvent( QMouseEvent * );
    void timerEvent( QTimerEvent * );
    void resizeEvent( QResizeEvent * );

private:
    void grab(void);

    QComboBox * zoom;
    QComboBox * refresh;
    QPixmap pm; // pixmap, magnified
    int z; // magnification factor
    int r; // autorefresh rate (index into refreshrates)
    bool grabbing; // true if qmag is currently grabbing

    int grabx, graby;
};

