/****************************************************************************
** $Id: dclock.cpp,v 1.5 1995/05/15 00:14:28 hanord Exp $
**
** Implementation of DigitalClock widget
**
** Authors : Eirik Eng and Haavard Nord
** Created : 941111
**
** Copyright (C) 1994,1995 by Troll Tech AS.  All rights reserved.
**
*****************************************************************************/

#include "dclock.h"
#include <qdatetm.h>


// ---------------------------------------------------------------------------
// InteractiveLCD member functions
//
// The QLCDNumber class is an output-only widget that does not handle
// mouse or keyboard events.
// Since we need to know when the LCD number is clicked, we simply
// inherit the QLCDNumber widget and reimplement the mouse press
// event handler and emit a signal called clicked() every time the
// user presses the left mouse button inside this widget.
// 

InteractiveLCD::InteractiveLCD( uint ndigits, QWidget *parent,
				const char *name )
    : QLCDNumber( ndigits, parent, name )
{
    initMetaObject();				// initialize meta object
}

void InteractiveLCD::mousePressEvent( QMouseEvent *e )
{
    if ( e->button() == LeftButton )		// left mouse button pressed
	emit clicked();
}


// ---------------------------------------------------------------------------
// DigitalClock member functions
//

DigitalClock::DigitalClock( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    initMetaObject();				// initialize meta object
    showingColon = FALSE;
    lcd = new InteractiveLCD( 5, this, "DigitalDisplay" );
    lcd->setFrameStyle( QFrame::Panel | QFrame::Raised );
    lcd->setLineWidth( 2 );			// set frame line width
    connect( lcd, SIGNAL(clicked()), SLOT(showDate()) );
    lcd->move( 0, 0 );				// move lcd widget to upperleft
    lcd->show();
    showTime();					// display the current time
    normalTimer = startTimer( 500 );		// 1/2 second timer events
    showDateTimer = -1;				// not showing date
}


bool DigitalClock::showingDate() const		// are we showing the date?
{
    return showDateTimer != -1;
}


void DigitalClock::timerEvent( QTimerEvent *e )
{
    if ( e->timerId() == showDateTimer )	// stop showing date
	stopDate();
    else {					// normal timer
	if ( !showingDate() )
	    showTime();
    }
}

void DigitalClock::resizeEvent( QResizeEvent *r )
{						// resize LCD display to fit
    lcd->resize( size() );
}


void DigitalClock::showDate()			// start showing the date
{
    if ( showingDate() )			// already showing date
	return;
    QDate d = QDate::currentDate();
    QString s;
    s.sprintf( "%2d %2d", d.month(), d.day() );
    lcd->display( s );
    showDateTimer = startTimer( 2000 );		// keep this state for 2 secs
}


void DigitalClock::stopDate()			// stop showing the date
{
    killTimer( showDateTimer );
    showDateTimer = -1;
    showTime();
}


void DigitalClock::showTime()			// show the time
{
    showingColon = !showingColon;		// toggle/blink colon
    QString s = QTime::currentTime().toString().left(5);
    if ( !showingColon )
	s[2] = ' ';
    if ( s[0] == '0' )
	s[0] = ' ';
    lcd->display( s );
}
