#include "matrix.h"

void matrix::poke(unsigned long x, unsigned long y, double a)
{
	#ifdef __RUN_TIME_CHECKING__
	if(x >= this->row || y >= this->col){
		cerr << "poke(): out of bounds element\n";
		exit(1);
	}
	#endif

	*(this->mat + this->col * x + y) = a;
}

double matrix::peek(unsigned long x, unsigned long y) const
{
 	#ifdef __RUN_TIME_CHECKING__
	if(x >= this->row || y >= this->col){
		cerr << "peek(): out of bounds element\n";
		exit(1);
	}
	#endif

	return *(this->mat + this->col * x + y);
}
