#include "matrix.h"

matrix matrix::lu(long& v, matrix& P) const
{
	unsigned long i, j, k, n;
	unsigned long maxi;
	double c, c1, tmp;
	long p;
	matrix A = *this;

	n = A.collen();

	{   // block, so tmp_P is very local.  all I want is to allocate
	    // space to P.  It would be faster to do it manually in here
	    // but it's tight and nice this way :)
		matrix tmp_P(n,1);
		P=tmp_P;
	}

	for (p = 0, i = 0; i < n; i++) P.poke(i,0,(double)i);

	for (k = 0; k < n; k++)
	{
		for (i = k, maxi = k, c = 0.0; i < n; i++)
		{
			c1 = A.peek((unsigned long)P.peek(i,0),k);
			c1 *= (c1 < 0 ? -1.0 : 1.0); // so I dont use fabs() and math.h
			if (c1 > c)
			{
				c = c1;
				maxi = i;
			}
		}

		if (k != maxi)
		{
			p++;
			tmp = P.peek(k,0);
			P.poke(k,0,P.peek(maxi,0));
			P.poke(maxi,0,tmp);
		}

		if (A.peek((unsigned long)P.peek(k,0),k) == 0.0){
			v = -1;
			return A;
		}

		for (i = k + 1; i < n; i++)
		{
			A.poke((unsigned long)P.peek(i,0),k, 
			A.peek((unsigned long)P.peek(i,0),k)
				/ A.peek((unsigned long)P.peek(k,0),k));

			for (j = k + 1; j < n; j++)
			    A.poke((unsigned long)P.peek(i,0),j,
					A.peek((unsigned long)P.peek(i,0),j) - 
					A.peek((unsigned long)P.peek(i,0),k) * 
					A.peek((unsigned long)P.peek(k,0),j));
		}
	}
  v=p;
  return (A);
}
