#include "matrix.h"

matrix matrix::operator ~() const // inverse
{

	#ifdef __RUN_TIME_CHECKING__
	if(this->rowlen() != this->collen()){
		cerr << "invalid matrix size: inverse on non-square matrix\n";
		exit(1);
	}
	#endif

	unsigned long i,n=this->rowlen();
	matrix A = *this, B(n,1), C(n,n), P; // C(n,n) because i is in [0,n]
	long v;								 // during the backsub part

	A=A.lu(v, P);
	if (v==-1) return C; // singular

	for(i=0; i<n; i++)
	{
		unsigned long f;
		for(f=0;f<n;f++) B.poke(f,0, 0.0); // fill B with zeros
		B.poke(i,0, 1.0);
		A.backsub(B,C,P,i);
	}
	return C;
}
