#include "matrix.h"

double matrix::cofactor(unsigned long i, unsigned long j)
{
	#ifdef __RUN_TIME_CHECKING__
	if(i >= this->rowlen() || j >= this->collen()){
		cerr << "cofactor(): out of bounds element\n";
		exit(1);
	}
	if(this->rowlen() != this->collen()){
		cerr << "invalid matrix size: cofactor on non-square matrix\n";
		exit(1);
	}                                
	#endif

	return ( this->minor(i,j) * ((i+j)%2 ? -1 : 1 ) );
}
