//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: LREG.h,v 0.27 1995/01/20 15:13:27 cncl-adm Exp cncl-adm $
 *
 * Class: CNLREG --- LRE evaluation G(x) (compl. distribution function)
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __LREG_h
#define __LREG_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/LRE.h>           // Base class

extern CNClassDesc CN_LREG;     // CNClass CNLREG description


/*
 * The class CNLREG
 */

class CNLREG : public CNLRE
{
  public:
    virtual void   put( double );

    // Private members
  private:
    void      neusort(struct result*);
    void      quicksort(struct sm*, struct sm*);
    struct sm *mergesort(struct sm*);
    void      verbesser(struct result*, struct result*, double, double);
    double    end_lev() {return MAXDOUBLE;};

    /***** Constructors ******************************************************/
public:
    CNLREG(double MIN=0.01, double MAX=0.99, double MAX_ERR=0.05,
           int LEVEL=100, Scale SCALE=CNLRE::LIN, int MAXSORT = 0, 
           char* NAME = "no name", char* TEXT = "no text")
        : CNLRE (MIN,MAX,MAX_ERR,LEVEL,SCALE,MAXSORT,NAME,TEXT)
    {
        rvakt       = -MAXDOUBLE;
        pr->xlevlim = -MAXDOUBLE;
    };
    CNLREG(CNParam *param) {}                   // CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const      // CNClass description
    {
        return CN_LREG;
    };
            
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    {
        return desc == CN_LREG ? TRUE : CNLRE::is_a(desc);
    };
        
    static CNLREG *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNLREG *)obj;
#   else
        return (CNLREG *)( obj->is_a(CN_LREG)
               ? obj : fatal_type(obj->class_desc(), CN_LREG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNLREG(param) : new CNLREG; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const
        { CNLRE::print( CNStatistics::CDF, strm ); }
//    virtual void dump (ostream &strm = cout) const;
};


#endif /**__LREG_h**/
