//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcess_Environment.h,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: SDLProcess_Environment --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __SDLProcess_Environment_h
#define __SDLProcess_Environment_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

//#include <CNCL/SDLProcess.h>		// Base class
#include "SDLProcess.h"

extern CNClassDesc CN_SDLPROCESS_ENVIRONMENT;	// Class SDLProcess_Environment description


/*
 * The class SDLProcess_Environment
 */

class SDLProcess_Environment : public CNSDLProcess
{
  public:	/***** Constructors ******************************************/
    SDLProcess_Environment() {}                         // Default constructor
    SDLProcess_Environment(CNParam *param) {}		// CNParam constructor
    
    SDLProcess_Environment(char*, CNSDLManager*, int);
    
  public:	/***** Public interface **************************************/
    int process(int);         

  private:	/***** Internal private members ******************************/



  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SDLPROCESS_ENVIRONMENT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SDLPROCESS_ENVIRONMENT ? TRUE : CNSDLProcess::is_a(desc); }
        
    static SDLProcess_Environment *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (SDLProcess_Environment *)obj;
#   else
	return (SDLProcess_Environment *)( !obj || obj->is_a(CN_SDLPROCESS_ENVIRONMENT)
	       ? obj : fatal_type(obj->class_desc(), CN_SDLPROCESS_ENVIRONMENT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new SDLProcess_Environment(param) : new SDLProcess_Environment; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__SDLProcess_Environment_h**/
