//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcessData.h,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLProcessData --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNSDLProcessData_h
#define __CNSDLProcessData_h

/*
    The class SDLProcessData now does the process managment. It contains
    a hash table with all active instances of a given process type and
    handles the low level parts of SDL process creation and deletion. It
    is also used by the class SDLManager to get the target process in
    sending signals.
*/


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

#include <CNCL/HashDynamic.h>
#include <CNCL/KeyInt.h>
#include <CNCL/SDLProcess.h>
 

extern CNClassDesc CN_SDLPROCESSDATA;	// Class CNSDLProcessData description


typedef int PId;
typedef int ProcessType;

/*
 * The class CNSDLProcessData
 */

class CNSDLProcessData : public CNObject
{
    
  public:
    ProcessType type();        // get process type
    int max_number();          // and max number of processes
    bool is_of_this_type(PId); 
    
    CNSDLProcess *get_process_by_PId(PId);
    CNSDLProcess *get_process_by_type();
    
    PId add_process(CNSDLProcess*, PId = 0);
    void delete_process(PId);
    
        
    // Private members
  private:
    void reorganize_default(PId = 0);
    void reset_default();
    
        
  private:  
    CNSDLProcess *act_address;  // memory address of process
    PId act_PId;
    
    ProcessType p_type;   // process_type (used for signal handling)
    int p_max;            // maximum number of processes of this type
    int p_first, p_last;
    
    CNHashDynamic process;  // HashTable of active instances of ProcessType
    long p_num;
    
    const int DEFAULT_SIZE = 10;
    PId default_PId[ DEFAULT_SIZE ];  // a kind of cache used with implicit
    PId last_created;                 // adress mode (via signal route)
    
    
    /***** Constructors ******************************************************/
  public:
    CNSDLProcessData(CNParam *param) {}			// CNParam constructor
    CNSDLProcessData(ProcessType, int, PId);
  
    ~CNSDLProcessData();
    
  private:
    CNSDLProcessData() {}                               // Default constructor
    
      
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SDLPROCESSDATA;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SDLPROCESSDATA ? TRUE : CNObject::is_a(desc);
    };
        
    static CNSDLProcessData *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNSDLProcessData *)obj;
#   else
        return (CNSDLProcessData *)( !obj || obj->is_a(CN_SDLPROCESSDATA)
               ? obj : fatal_type(obj->class_desc(), CN_SDLPROCESSDATA) );
#   endif
    }
    
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL)
    {return param ? new CNSDLProcessData(param) : new CNSDLProcessData; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};




// now the inlines

inline ProcessType CNSDLProcessData::type() { return p_type; }
inline int CNSDLProcessData::max_number()   { return p_max; }
inline bool CNSDLProcessData::is_of_this_type(PId pid)
{ return ((pid >= p_first) && (pid <= p_last)) ? true : false; }

#endif /**__CNSDLProcessData_h**/
