//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcessData.c,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLProcessData --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "SDLProcessData.h"


    // setting up PId adress range for current process type
CNSDLProcessData::CNSDLProcessData(ProcessType pt, int pn, PId first)
: act_address(NIL), act_PId(0), process(), p_num(0)
{
    p_max = pn;
    p_type = pt;
    p_last = (p_first = first) + p_max - 1;
    for (int i=0; i<DEFAULT_SIZE; i++) default_PId[i] = 0;
    last_created = p_first - 1;
}



    // clean up
CNSDLProcessData::~CNSDLProcessData()
{
    for (int i=p_first; i<=p_last; i++)
    {
        CNKey *pro = new CNKeyInt(i);
        CNSDLProcess *proc_ad = (CNSDLProcess *) process.get_object(pro);
        if (proc_ad) delete proc_ad;
        delete pro;
    }  
    process.reset_absolutely();
}



CNSDLProcess *CNSDLProcessData::get_process_by_PId(PId pid)
{
    CNKeyInt pro(pid);
    CNObject *obj;
    
    if(!(obj = process.get_object(&pro)))
        error("CNSDLProcessData::get_process_by_PId", 
              " no process with given PId");
    
    return (CNSDLProcess*) obj;
}



CNSDLProcess *CNSDLProcessData::get_process_by_type()
{
    if (!p_num) 
        error("CNSDLProcessData::get_process_by_type",
              " no process availiable");
    
    return act_address;
}



PId CNSDLProcessData::add_process(CNSDLProcess* adr, PId pid)
{
    CNKey *pro, *h;
    bool ok = false;
    
        // static creation when pid is given
    if(pid)
    {
        if (pid<p_first || pid>p_last)
            fatal("CNSDLProcessData::add_process"," wrong PId");
                  
        pro = new CNKeyInt(pid, adr);
        process.store_key(pro);
        
            // set up default for implicit address mode
        if (!act_PId)
        {
            act_PId = pid;
            act_address = adr;
        }
        else
        {
            for (int i=0; i<DEFAULT_SIZE; i++)
                if (!default_PId[i]) 
                {
                    default_PId[i] = pid;
                    break;
                }
        }
        last_created = pid;
        p_num++;
    }
    else    // dynamic process creation, so we'll calculate the pid here
    {
        if (p_num < p_max)
        {
            pid = last_created;
            while (++pid <= p_last)
            {
                pro = new CNKeyInt(pid, adr);
                if (!(h = process.get_key(pro)))
                {
                    process.store_key(pro);
                    ok = true;
                    break;
                }
                else delete pro;
            }
            if (!ok)  // wrap around address range
            {
                pid = p_first - 1;
                while(++pid <= last_created)
                { 
                    pro = new CNKeyInt(pid, adr);
                    if (!(h = process.get_key(pro)))
                    {
                        process.store_key(pro);
                        ok = true;
                        break;
                    }
                    else delete pro;
                }
            }
                // setup default for implicit address mode
            if (ok)
            {
                if (!act_PId)
                {
                    act_PId = pid;
                    act_address = adr;
                }
                else
                {
                    for (int i=0; i<DEFAULT_SIZE; i++)
                        if (!default_PId[i]) 
                        {
                            default_PId[i] = pid;
                            break;
                        }
                }
                last_created = pid;
                p_num++;        
            }
            else pid = 0;
        }
    }
    
    return pid;
}



void CNSDLProcessData::delete_process(PId pid)
{
    CNKeyInt pro(pid);
    bool ok = process.delete_key_absolutely(&pro);
    
    if (!ok) 
        warning("CNSDLProcessData::delete_process",    
                " couldn't delete process");
    else
    {
        p_num--;
        if (pid == act_PId)
        {
            act_PId = default_PId[0];
            reorganize_default();
            if (act_PId)
            {
                CNKeyInt npr(act_PId);
                act_address = (CNSDLProcess*) process.get_object(&npr);
            }
            else act_address = NIL;
        }
        else reorganize_default(pid);
    }
}
    
    

void CNSDLProcessData::reorganize_default(PId pid)
{
    bool ok = false;
    int i,j;
    if (!pid)
    {
        for (i=DEFAULT_SIZE-1; i>0; i--)
            if (default_PId[i]) 
            {
                default_PId[0] = default_PId[i];
                default_PId[i] = 0;
                ok = true;
                break;
            }
        if (!ok) reset_default();
    }
    else
    {
        for (i=0; i<DEFAULT_SIZE; i++)
            if (default_PId[i] == pid)
            {
                default_PId[i] = 0;
                j = i;
                ok = true;
                break;
            }
        if (ok)
            for (i=DEFAULT_SIZE-1; i>j; i--)
                if (default_PId[i])
                {
                    default_PId[j] = default_PId[i];
                    default_PId[i] = 0;
                    break;
                }
    }
}


     
void CNSDLProcessData::reset_default()
{
    if (p_num)
    {
        short found = 0, 
              to_find = (p_num > DEFAULT_SIZE) ? DEFAULT_SIZE : p_num;
        PId searched = p_first;
        CNKey *h, *hh;
        
        while (searched < p_last)
        {
            h = new CNKeyInt(searched);
            if (hh = process.get_key(h))
            {
                default_PId[found] = searched;
                if (++found >= to_find) break;
            }
            delete h;
            searched++;
        }
        if (!act_PId)
        {
            act_PId = default_PId[found-1];
            h = new CNKeyInt(act_PId);
            act_address = (CNSDLProcess*) process.get_key(h);
            delete h;
        }
    }
}




/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLProcessData::print(ostream &strm) const
{
    strm << endl;
}

// Debug output
void CNSDLProcessData::dump(ostream &strm) const
{
    strm << "CNSDLProcessData { $Revision: 0.27 $ ..." << endl;
    strm << "type=" << p_type << " max. number of processes=" 
         << p_max << endl;   
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLProcessData
static CNClass CNSDLProcessData_desc("CNSDLProcessData", "$Revision: 0.27 $",
			    CNSDLProcessData::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESSDATA = &CNSDLProcessData_desc;

