// -*- C++ -*-

/*
 * Test program for random number generators
 */

#include <string.h>

#include <CNCL/Moments.h>

#include <CNCL/RNG.h>
#include <CNCL/FiboG.h>

#include <CNCL/Tab.h>
#include <CNCL/InterTab.h>
#include <CNCL/DiracTab.h>


enum { NRANDOM = 20, NVAL = 100000 };


char buffer[128];



main()
{
    CNRNG *gen;
    CNRandom *rng[NRANDOM];
    int i, j;
    int n = 0;

    gen = new CNFiboG;

    double x[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
    CNDiracTabEntry dx[] = {
        {0.5,0.1}, {1.5,0.2}, {2.5,0.3}, {3.5,0.4}, {4.5,0.5}, {5.5,0.6},
        {6.5,0.7}, {7.5,0.8}, {8.5,0.9}, {9.5,1.0}
    };

    rng[n++] = new CNTab(x, sizeof(x)/sizeof(double), gen);
    rng[n++] = new CNInterTab(x, sizeof(x)/sizeof(double), gen);
    rng[n++] = new CNDiracTab(dx, sizeof(dx)/sizeof(CNDiracTabEntry), gen);
    rng[n++] = NIL;

    for(i=0; rng[i]; i++)
    {
	rng[i]->dump();
	
	strcpy(buffer, rng[i]->class_desc()->name());
	strcat(buffer, " ");
	strcat(buffer, rng[i]->class_desc()->version());
	
	CNMoments stat(buffer);
	    
	for(j=0; j<NVAL; j++)
	    stat.put(rng[i]->operator()());
	    
	cout << stat << endl;
    }
}
