//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FileG.c,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNFileG --- Created from CNCL template
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "FileG.h"



CNFileG::CNFileG(char *s, bool par)
{
    name=strdup(s);
    assert(name!=NULL);
    parity=par;
    reset();
}



CNFileG::~CNFileG()
{
    fclose(fp);
    free(name);
}



CNFileG::CNFileG()
{}



CNFileG::CNFileG(CNParam *param)
{}



void CNFileG::reset()
{
    fp=fopen(name,"r");
    assert(fp!=NULL);
    count=0;
     
    if(parity)
    {
        wrong_parity_count=0; long_count=long_max_count=0;
        short f_error=fseek(fp, 0L, 2); //position pointer to end of file
        assert(f_error==0);
        file_length=ftell(fp);
        rewind(fp);
        if(file_length % PURAN2_PAR_BLCK_SIZE)
        {
            error(err_warning,
            "FileG::reset: Puran2 data truncated to multiple of block length");
            file_length -= file_length%PURAN2_PAR_BLCK_SIZE;
        }
        unsigned char byte;
        for(int byte_value=0; byte_value<256; byte_value++)
        {
            parity_bit[byte_value]=0;      // compute parity bits for
            byte=byte_value;               // all values 0 to 255
            for(int bit=0; bit<8; bit++)
            {
                if(byte & 0x80) parity_bit[byte_value]++;
                byte <<= 0x1;
            }
            parity_bit[byte_value] &= 0x1; // even or odd
        }
    }    
}



unsigned long CNFileG::as_long32()
{
    unsigned long l;

    if(!parity)
    {
        if (!fread(&l,4,1,fp))
        {
	    if (++count>4)
	        count=0;
	    fclose(fp);
	    fp=fopen(name,"r");
	    assert(fp!=NULL);
	    fseek(fp,count,0);
	    fread(&l,4,1,fp);
        }
    }
    else // Puran2 with parity
    {
        if(long_max_count==long_count) read_buffer();
        l=buffer[long_count++];
    }     

    return(l);
}



void CNFileG::read_buffer()
{
    if(!remaining_data())
    {
        fclose(fp);
        reset();
    }
    //read data into temporary buffer first
    unsigned char tmp_buffer[PURAN2_PAR_BUF_SIZE];
    long bytes_read=fread(tmp_buffer, 1, PURAN2_PAR_BUF_SIZE, fp);
    if(bytes_read<PURAN2_PAR_BUF_SIZE) 
        error("FileG::read_buffer: read error");
    long_max_count=(bytes_read/PURAN2_PAR_BLCK_SIZE)*(PURAN2_BLCK_SIZE/4);
    long_count=0;
    unsigned char *end_of_buffer=(unsigned char*)buffer + 
                        (bytes_read/PURAN2_PAR_BLCK_SIZE) * PURAN2_BLCK_SIZE;
    unsigned char *tmp_buffer_pos=tmp_buffer;
    unsigned char *block;
    for (block=(unsigned char*)buffer; block<end_of_buffer;
         block+=PURAN2_BLCK_SIZE)
    {
        memcpy(block,tmp_buffer_pos,PURAN2_BLCK_SIZE);  // copy block to
        tmp_buffer_pos+=PURAN2_BLCK_SIZE;               // regular buffer
        unsigned long *l=(unsigned long*)block;
        unsigned char *c=block;
        unsigned long horizontal=0, vertical=0;    // parity
        for(int i=31; i>=0; i--)
        {
            int long_parity=0;
            for(int j=0; j<4; j++) long_parity^=*c++;  // xor with each byte      
            horizontal |= (parity_bit[long_parity] & 0x1) << i;
            vertical ^= *l++;
        }
        c=(unsigned char*) &horizontal;  // byte swapping
        char tmp=c[0]; c[0]=c[3]; c[3]=tmp;
             tmp=c[1]; c[1]=c[2]; c[2]=tmp;
        if (vertical!=*(unsigned long*)tmp_buffer_pos)
        {
            error(err_warning, "FileG: vertical parity error");
            wrong_parity_count++;
        }
        if (horizontal!=*(unsigned long*)(tmp_buffer_pos+4))
        {
            error(err_warning, "FileG: horizontal parity error");
            wrong_parity_count++;
        }
        tmp_buffer_pos+=8;
    }
    return;
}



unsigned long CNFileG::remaining_data()
{
    unsigned long act_pos=ftell(fp);
    unsigned long unread_data=file_length-act_pos;
    unread_data=(unread_data/PURAN2_PAR_BLCK_SIZE) * PURAN2_BLCK_SIZE;
    return unread_data+(long_max_count-long_count)*4;
}



void CNFileG::newfile(char *s, bool par)
{
    fclose(fp);
    free(name);
    name=strdup(s);
    assert(name!=NULL);
    parity=par;
    reset();
}
                        
                        

/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNFileG::print(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "\"" << name << "\"" << endl;
}

// Debug output
void CNFileG::dump(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "CNFileG { "
	 << "\"" << name << "\"" << endl
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNFileG
static CNClass CNFileG_desc("CNFileG", "$Revision: 0.27 $", CNFileG::new_object);

// "Type" for type checking functions
CNClassDesc CN_FILEG = &CNFileG_desc;






