// -*- C++ -*-

//    SocketBuf derived from libg++ 2.3 filebuf implementation

//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public


#ifndef _SOCKETBUF_H
#define _SOCKETBUF_H

#include <CNCL/CNCL.h>

#include <_G_config.h>
#ifdef _G_NEED_STDARG_H
#include <stdarg.h>
#endif

#ifndef EOF
#define EOF (-1)
#endif
#ifndef NULL
#define NULL ((void*)0)
#endif

#include <streambuf.h>


class SocketBuf : public streambuf {
  private:
    enum { BUFSIZE = 1024 };
  protected:
    void init();
  public:
    SocketBuf();
    SocketBuf(int fd);
    ~SocketBuf();

    SocketBuf* attach(int fd);
    SocketBuf* close();

    virtual int underflow();
    virtual int overflow(int c = EOF);

    int is_open() const { return _fileno >= 0; }
    int fd() const { return is_open() ? _fileno : EOF; }

    virtual int doallocate();

    virtual int sync();


  protected: // See documentation in filebuf.cc.
    int is_reading() { return eback() != egptr(); }
    char* cur_ptr() { return is_reading() ?  gptr() : pptr(); }
    /* System's idea of pointer */
    char* file_ptr() { return eGptr(); }

    int do_write(const char *data, int to_do);
    int do_flush() { return do_write(pbase(), out_waiting()); }

    // Low-level operations (Usually invoke system calls.)
    virtual streamsize sys_read(char* buf, streamsize size);
    virtual streamsize sys_write(const char*, streamsize);
    virtual int sys_close();
};

#endif /* _SOCKETBUF_H */
