// -*- C++ -*-


// GIST -- Graphical Interactive Simulation result Tool

//   CNCL interface classes

//   1992,93 Martin Horneffer

#include "gist_impl.hh"

GISTWorldImpl::GISTWorldImpl(const char *name) {
    name_ = new char[strlen(name)+1];
    strcpy(name_,name);
};
GISTWorldImpl::~GISTWorldImpl() { delete [] name_; };

GISTObjectImpl::GISTObjectImpl(const char *name) {
    attributes = 0;
    graphics = 0;
    name_ = new char[strlen(name)+1];
    strcpy(name_,name);
};
GISTObjectImpl::~GISTObjectImpl() { delete [] name_; };

GISTAttributeImpl::GISTAttributeImpl(GISTObject *parent,const char *name) {
    name_ = new char[strlen(name)+1];
    strcpy(name_,name);
    parent_ = parent;
};
GISTAttributeImpl::~GISTAttributeImpl() { delete [] name_; };

GISTCoordArrayAttributeImpl::GISTCoordArrayAttributeImpl(GISTObject *parent,const char *name,unsigned short dim): GISTAttributeImpl(parent,name) {
    bufdim = dim;
    buf = new float[bufdim*2];
};

GISTGraphicImpl::GISTGraphicImpl(GISTObject *parent,const char *name) {
    name_ = new char[strlen(name)+1];
    strcpy(name_,name);
    parent_ = parent;
};

GISTPictureImpl::GISTPictureImpl(GISTObject *parent,const char*name):
  GISTGraphicImpl(parent,name) {};
