//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventScheduler.c,v 0.27 1995/01/20 15:14:33 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNEventScheduler --- CNEvent scheduler
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER******************************************************************/

#include "EventScheduler.h"



/*
 * Contructors
 */
CNEventScheduler::CNEventScheduler()
	: CNEventBaseSched(), list()
{}


CNEventScheduler::CNEventScheduler(CNParam *param)
	: CNEventBaseSched(), list()
{}



/*
 * Add events to list
 */
void CNEventScheduler::send_event(CNEvent *ev)
{
    ev->issued(simtime);
    list.add_event(ev);
}



void CNEventScheduler::add_event(CNEvent *ev)
{
    ev->issued(simtime);
    list.add_event(ev);
}



/*
 * Delete events from list
 */
void CNEventScheduler::delete_event(CNEventID id)
{
    list.delete_event(id);
}



/*
 * Delete events from list
 */
void CNEventScheduler::delete_events(CNEventHandler *evh)
{
    list.delete_events(evh);
}



/*
 * Peek at next event
 */
CNEvent *CNEventScheduler::peek_event()
{
    return list.peek_event();
}


CNEvent *CNEventScheduler::peek_event(CNEventID id)
{
    return list.peek_event(id);
}



/*
 * Start scheduler
 */
void CNEventScheduler::start(CNEvent *ev)
{
    add_event(ev);
    process_events();
}


void CNEventScheduler::start()
{
    process_events();
}



/*
 * Stop scheduler by setting flag
 */
void CNEventScheduler::stop()
{
    stop_flag = TRUE;			// Set stop flag
    list.delete_all();			// and delete all events in the list
}



/*
 * CNEvent processing loop
 */
void CNEventScheduler::process_events()
{
    CNEvent *ev;
    CNEventHandler *handler;

    stop_flag = FALSE;
    
    // Process events from list
    while(ev = list.next_event())
    {
	simtime = ev->scheduled();
	handler = ev->to();
	handler->process_event(this, simtime, ev);
	delete ev;

	// Stop event processing, if flag set. Events stay in list.
	if(stop_flag)
	    break;
    }

    // No more events, terminate.
}


CNEventIterator *CNEventScheduler::create_iterator()
{
    return new CNEventLIterator(&list);
}


    
/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNEventScheduler::print(ostream &strm) const
{
    list.print(strm);
}

// Debug output
void CNEventScheduler::dump(ostream &strm) const
{
    strm << "CNEventScheduler { $Revision: 0.27 $" << endl;
    list.dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNEventScheduler
static CNClass CNEventScheduler_desc("CNEventScheduler", "$Revision: 0.27 $",
				 CNEventScheduler::new_object);

// "Type" for type checking functions
CNClassDesc CN_EVENTSCHEDULER = &CNEventScheduler_desc;






