//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventLIterator.c,v 0.27 1995/01/20 15:14:33 cncl-adm Exp cncl-adm $
 *
 * Class: CNEventLIterator --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include <CNCL/Class.h>

#include "EventLIterator.h"

// initialize iterator with first element of eventlist
CNEventLIterator::CNEventLIterator(CNEventList *ev_list)
{
    elist = ev_list;
    act_event = elist->peek_event();
    use_current = TRUE;
}



// traverse eventlist (here it is guaranteed that every event is processed
// exactly once)
CNEvent *CNEventLIterator::next_event()
{
    if (use_current) 
        use_current = FALSE;	// don't run too fast 
    else 
        act_event = act_event ? (CNEvent *)(act_event->next()) : NIL;
    
    return act_event;
}



// delete the event delivered last time, then adjust list position.
// never delete an event not yet delivered
void CNEventLIterator::delete_current_event()
{
    if ((!act_event) || use_current) return;	// don't delete too far  
     
    CNEvent *next = (CNEvent *)(act_event->next());   
    elist->ev_list.delete_object(act_event);	// delete from list
    
    act_event = next;
    use_current = TRUE;
}



          
/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNEventLIterator::print(ostream &strm) const
{
    strm << "current event: " << act_event << endl;
}

// Debug output
void CNEventLIterator::dump(ostream &strm) const
{
    strm << "CNEventLIterator { $Revision: 0.27 $ ..." << endl;
    strm << "current event-list: " << elist << endl
         << "current event: " << act_event << endl;
    strm << " }" << endl;
}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNEventLIterator &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNEventLIterator *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNEventLIterator
static CNClass CNEventLIterator_desc("CNEventLIterator", "$Revision: 0.27 $",
			    /*CNEventLIterator::new_object*/ NIL);

// "Type" for type checking functions
CNClassDesc CN_EVENTLITERATOR = &CNEventLIterator_desc;
