//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: IntAVLNode.h,v 1.3 1994/02/03 18:25:26 maho Exp maho $
 *
 * Class: IntAVLNode --- example using CNAVLNode
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __IntAVLNode_h
#define __IntAVLNode_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/AVLNode.h>		// Base class
#include <CNCL/AVLTree.h>

extern CNClassDesc CN_INTAVLNODE;	// Class IntAVLNode description


/*
 * The class IntAVLNode
 */

class IntAVLNode : public CNAVLNode
{
  public:	/***** Constructors ******************************************/

    IntAVLNode(long key): key_(key) {};

  public:	/***** Public interface **************************************/

    virtual int compare(CNAVLNode*); // compare node with another one
    virtual int find(CNAVLTree*);    // compare node with searched key  
    long get_key() { return key_; };

  private:	/***** Internal private members ******************************/

    long key_;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_INTAVLNODE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_INTAVLNODE ? TRUE : CNAVLNode::is_a(desc); }
        
    static IntAVLNode *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (IntAVLNode *)obj;
#   else
	return (IntAVLNode *)( !obj || obj->is_a(CN_INTAVLNODE)
	       ? obj : fatal_type(obj->class_desc(), CN_INTAVLNODE) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__IntAVLNode_h**/
