//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLList.c,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDLList --- Double linked list
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include <values.h>

#include "DLList.h"



bool CNDLList::ok()
{
    int v = TRUE;
    if (pfirst)
    {
	CNDLObject *p;
	long num = MAXLONG;      // Lots of chances to find h!

	for(p=pfirst; p && v && num>0; p=p->pnext)
	{
	    if(p->pprev)
		v &= p->pprev->pnext == p;
	    if(p->pnext)
		v &= p->pnext->pprev == p;
	}
	v &= num > 0;
    }
    if(!v)
	fatal(NIL, "CNDLList: ", "invariant failure");
    return v;
}



/*
 * Remove node from list, do NOT delete DLObject
 */
CNDLObject *CNDLList::remove_object(CNDLObject *pos)
{
    CNDLObject *p, *n;
    
    p = pos->pprev;
    n = pos->pnext;
    
    if(p)
	p->pnext = n;
    else
	pfirst   = n;
    if(n)
	n->pprev = p;
    else
	plast    = p;
    
    count--;
    
    return n;
}



/*
 * Remove node from list, delete DLObject
 */
CNDLObject *CNDLList::delete_object(CNDLObject *pos)
{
    CNDLObject *p, *n;
    
    p = pos->pprev;
    n = pos->pnext;
    
    if(p)
	p->pnext = n;
    else
	pfirst   = n;
    if(n)
	n->pprev = p;
    else
	plast    = p;
    
    delete pos;
    count--;
    
    return n;
}



/*
 * Delete the entire list, all DLObject nodes,
 * but NOT the referenced objects.
 */
void CNDLList::delete_all()
{
    CNDLObject *p, *n;
    
    for(p=pfirst; p;)
    {
	n = p->pnext;
	delete p;
	p = n;
    }
    pfirst = plast = NIL;
    count  = 0;
}



/*
 * Delete the entire list, all DLObject nodes,
 * AND the referenced objects.
 */
void CNDLList::delete_all_w_obj()
{
    CNDLObject *p, *n;
    
    for(p=pfirst; p;)
    {
	p->delete_object();		// Delete referenced object, too
	n = p->pnext;
	delete p;
	p = n;
    }
    pfirst = plast = NIL;
    count  = 0;
}



CNDLObject *CNDLList::insert_before(CNDLObject *pos, CNObject *obj)
{
    return insert_before(pos, new CNDLObject(obj));
}

CNDLObject *CNDLList::insert_before(CNDLObject *pos, CNObject &obj)
{
    return insert_before(pos, new CNDLObject(&obj));
}

CNDLObject *CNDLList::insert_before(CNDLObject *pos, CNDLObject *obj)
{
    CNDLObject *p;
    
    p = pos->pprev;
    if(p)
	p->pnext = obj;
    else
	pfirst   = obj;
    obj->pprev = p;
    obj->pnext = pos;
    pos->pprev = obj;
    count++;
    
    return obj;
}


CNDLObject *CNDLList::insert_after(CNDLObject *pos, CNObject *obj)
{
    return insert_after(pos, new CNDLObject(obj));
}

CNDLObject *CNDLList::insert_after(CNDLObject *pos, CNObject &obj)
{
    return insert_after(pos, new CNDLObject(&obj));
}

CNDLObject *CNDLList::insert_after(CNDLObject *pos, CNDLObject *obj)
{
    CNDLObject *n;
    
    n = pos->pnext;
    if(n)
	n->pprev = obj;
    else
	plast   = obj;
    obj->pnext = n;
    obj->pprev = pos;
    pos->pnext = obj;
    count++;
    
    return obj;
}



CNDLObject *CNDLList::append(CNObject *obj)
{
    return append(new CNDLObject(obj));
}

CNDLObject *CNDLList::append(CNObject &obj)
{
    return append(new CNDLObject(&obj));
}

CNDLObject *CNDLList::prepend(CNObject *obj)
{
    return prepend(new CNDLObject(obj));
}

CNDLObject *CNDLList::prepend(CNObject &obj)
{
    return prepend(new CNDLObject(&obj));
}


CNDLObject *CNDLList::append(CNDLObject *link)
{
    if(pfirst)
    {
	plast->pnext = link;
	link ->pprev = plast;
	link ->pnext = NIL;
	plast        = link;
    }
    else
    {
	pfirst = plast = link;
	link->pnext = link->pprev = NIL;
    }
    count++;

    return link;
}

CNDLObject *CNDLList::prepend(CNDLObject *link)
{
    if(pfirst)
    {
	pfirst->pprev = link;
	link  ->pnext = pfirst;
	link  ->pprev = NIL;
	pfirst        = link;
    }
    else
    {
	pfirst = plast = link;
	link->pnext = link->pprev = NIL;
    }
    count++;

    return link;
}


	

/***** Default I/O member function for CNCL classes **************************/

// ***** Change this for your class *****

// CNNormal output
void CNDLList::print(ostream &strm) const
{
    CNDLObject *p;

    for(p=first(); p; p=p->next())
	strm << p;
}

// Debug output
void CNDLList::dump(ostream &strm) const
{
    CNDLObject *p;

    strm << "CNDLList { "
	 << "$Revision: 0.27 $  count=" << count << endl;
    for(p=first(); p; p=p->next())
	p->dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNDLList
static CNClass CNDLList_desc("CNDLList", "$Revision: 0.27 $", CNDLList::new_object);

// "Type" for type checking functions
CNClassDesc CN_DLLIST = &CNDLList_desc;






