//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: AVLTree.c,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * Class: CNAVLTree --- AVL balanced binary search tree
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "AVLTree.h"

CNAVLTree::CNAVLTree(): root(NIL), count(0) {};		
CNAVLTree::CNAVLTree(CNParam *param): root(NIL), count(0) {};


// add a node

static bool grown;
static CNAVLNode *node;

bool CNAVLTree::add(CNAVLNode *newnode) {
    node = newnode;
    return add_(root);
};
bool CNAVLTree::add_(CNAVLNode *&n) {
    bool res = TRUE;
    CNAVLNode *n1,*n2;
    if (!n) {
	count++;
	grown = TRUE;
	n = node;
	n->l = NIL; n->r = NIL; n->bal = 0;
    } else {
	int c = n->compare(node);
	if (c>0) {
	    res = add_(n->l);
	    if (grown) {
		switch (n->bal) {
		  case  1: grown = FALSE; 
		  case  0: n->bal -= 1; break;
		  case -1: 
		    n1 = n->l;
		    if (n1->bal < 0) {
			n->l = n1->r;
			n1->r = n;
			n->bal = 0;
			n = n1;
		    } else {
			n2 = n1->r;
			n1->r = n2->l;
			n2->l = n1;
			n->l = n2->r;
			n2->r = n;
			n->bal  = (n2->bal < 0) ?  1 : 0;
			n1->bal = (n2->bal > 0) ? -1 : 0;
			n = n2;
		    };
		    n->bal = 0;
		    grown = FALSE;
		};
	    };
	} else if (c<0) {
	    res = add_(n->r);
	    if (grown) {
		switch (n->bal) {
		  case -1: grown = FALSE;
		  case  0: n->bal += 1; break;
		  case  1: 
		    n1 = n->r;
		    if (n1->bal > 0) {
			n->r = n1->l;
			n1->l = n;
			n->bal = 0;
			n = n1;
		    } else {
			n2 = n1->l;
			n1->l = n2->r;
			n2->r = n1;
			n->r = n2->l;
			n2 ->l = n;
			n->bal  = (n2->bal > 0) ? -1 : 0;
			n1->bal = (n2->bal < 0) ?  1 : 0;
			n = n2;
		    };
		    n->bal = 0;
		    grown = FALSE;
		};
	    };
	} else {
	    grown = FALSE;
	    res = FALSE;
	};
    };
    return res;
};


// find and remove a node

static bool h;
static CNAVLNode *New;

void CNAVLTree::balL_(CNAVLNode *&n) {
    CNAVLNode *n1;
    CNAVLNode *n2;
    int b1;
    int b2;
    switch (n->bal) {
      case  0: h = FALSE;
      case -1: n->bal += 1; break;
      case  1:            // rebalance
	n1 = n->r;
	b1 = n1->bal;
	if (b1 >= 0) {    // single RR rotation
	    n->r = n1->l;
	    n1->l = n;
	    if (b1 == 0) {
		n->bal = 1;
		n1->bal = -1;
		h = FALSE;
	    } else {
		n->bal = 0;
		n1->bal = 0;
	    };
	    n = n1;
	} else {          // double RL rotation
	    n2 = n1->l;  b2 = n2->bal;
	    n1->l = n2->r;
	    n2->r = n1;
	    n ->r = n2->l;
	    n2->l = n;
	    n ->bal = (b2 > 0) ? -1 : 0;
	    n1->bal = (b2 < 0) ?  1 : 0;
	    n = n2;
	    n2->bal = 0;
	};
    };
};

void CNAVLTree::balR_(CNAVLNode *&n) {
    CNAVLNode *n1;
    CNAVLNode *n2;
    int b1;
    int b2;
    switch (n->bal) {
      case  0: h = FALSE;
      case  1: n->bal -= 1; break;
      case -1:            // rebalance	
	n1 = n->l;
	b1 = n1->bal;
	if (b1 <= 0) {    // single LL rotation
	    n->l = n1->r;
	    n1->r = n;
	    if (b1 == 0) {
		n->bal = -1;
		n1->bal = 1;
		h = FALSE;
	    } else {
		n->bal = 0;
		n1->bal = 0;
	    };
	    n = n1;
	} else {          // double LR rotation
	    n2 = n1->r;  
	    b2 = n2->bal;
	    n1->r = n2->l;
	    n2->l = n1;
	    n ->l = n2->r;
	    n2->r = n;
	    n ->bal = (b2 < 0) ?  1 : 0;
	    n1->bal = (b2 > 0) ? -1 : 0;
	    n = n2;
	    n2->bal = 0;
	};
    };
};
CNAVLNode *CNAVLTree::remove() {
    h = FALSE;
    return rem_(root);
};
CNAVLNode *CNAVLTree::rem_(CNAVLNode *&n) {
    CNAVLNode *Q = NIL;
    if (n) {
	int c = n->find(this);
	if (c > 0) {
	    Q = rem_(n->l);
	    if (h) balL_(n);
	} else if (c < 0) {
	    Q = rem_(n->r);
	    if (h) balR_(n);
	} else {
	    Q = n;
	    if (!n->r) {
		n = n->l;
		h = TRUE;
	    } else if (!n->l) {
		n = n->r;
		h = TRUE;
	    } else {
		del_(n->l);
		n = New;
		n->l = Q->l;
		n->r = Q->r;
		n->bal = Q->bal;
		if (h) balL_(n);
	    };
	    Q->l = NIL;
	    Q->r = NIL;
	    Q->bal = 0;
	    count--;
	};
    };
    return Q;
};
void CNAVLTree::del_(CNAVLNode *&m) {
    if (m->r) {
	del_(m->r);
	if (h) balR_(m);
    } else {
	New = m;
	m = m->l;
	h = TRUE;
    };
};

CNAVLNode *CNAVLTree::remove_first() {
    h = FALSE;
    return rem_first_(root);
};
CNAVLNode *CNAVLTree::rem_first_(CNAVLNode *&n){
    CNAVLNode *Q = NIL;
    if (n) {
	if (n->l) {
	    Q = rem_first_(n->l);
	    if (h) balL_(n);
	} else {
	    Q = n;
	    if (!n->r) {
		n = n->l;
		h = TRUE;
	    } else if (!n->l) {
		n = n->r;
		h = TRUE;
	    } else {
		del_(n->l);
		n = New;
		n->l = Q->l;
		n->r = Q->r;
		n->bal = Q->bal;
		if (h) balL_(n);
	    };
	    Q->l = NIL;
	    Q->r = NIL;
	    Q->bal = 0;
	    count--;
	};
    };
    return Q;
};


// simply find a node

CNAVLNode *CNAVLTree::find() {
    CNAVLNode *n = root;
    int c;
    while (n) {
	c = n->find(this);
	if      (c<0) n = n->r;
	else if (c>0) n = n->l;
	else          return n;
    };
    return n;
};
CNAVLNode *CNAVLTree::find_first() {
    CNAVLNode *n = root;
    if (n) while (n->l) n = n->l;
    return n;
};


// other ...

bool CNAVLTree::empty() { 
    return root==NIL; 
};
void CNAVLTree::delete_all() {
    delete root;
    root = NIL;
    count = 0;
};



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNAVLTree::print(ostream &strm) const
{
    strm << "count=" << count << endl
	 << "tree:" << endl;
    if (root) root->print_tree(strm,0);
}

// Debug output
void CNAVLTree::dump(ostream &strm) const
{
    strm << "CNAVLTree { $Revision: 0.27 $  count=" << count << endl;
    if (root) root->dump_tree(strm,0);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNAVLTree
static CNClass CNAVLTree_desc("CNAVLTree", "$Revision: 0.27 $",
			    CNAVLTree::new_object);

// "Type" for type checking functions
CNClassDesc CN_AVLTREE = &CNAVLTree_desc;
