//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArrayObject  --- CNObjPtr array class
 *
 * Created from
 * $Id: T_array.hP,v 0.27 1995/01/20 15:14:47 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __ArrayObject_h
#define __ArrayObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Array.h>

extern CNClassDesc CN_ARRAYOBJECT;	// CNClass CNArrayObject description


/*
 * The class CNArrayObject
 */

typedef CNObject *CNObjPtr;

class CNArrayObject : public CNArray
{
  public:	/***** Public interface **************************************/
    virtual void size(int sz=0);		// Set size of array

    void put(int index, CNObjPtr value)	// Put value into array
    {
#   ifndef NO_RANGE_CHECK
	if(index<0 || asize<=index)
	    range_error(index);
	else
#   endif
	    array[index] = value;
    }

    CNObjPtr get(int index) const		// Get value from array
    {
#   ifndef NO_RANGE_CHECK
	if (index<0 || asize<=index)
	{   range_error(index); return 0; }
	else
#   endif
	    return array[index];
    }

    CNObjPtr& operator[] (int index)	// Operator []
    {
#   ifndef NO_RANGE_CHECK
	if (index<0 || asize<=index)
	    range_error(index);
#   endif
	return array[index];
    }

  private:	/***** Internal private members ******************************/
    friend class CNPArrayObject;
    
    CNObjPtr *array;			// Array of CNObjPtr
    CNObjPtr def_val;			// Default value
    
    void init(int sz);			// Initialize array
    void delete_array();                // Delete array

  public:	/***** Constructors ******************************************/
    CNArrayObject()               : CNArray((unsigned)0), array(NIL), def_val(0) {}
    CNArrayObject(CNParam *param) : CNArray((unsigned)0), array(NIL), def_val(0) {}
    CNArrayObject(int sz, CNObjPtr def=0);
    CNArrayObject(const CNArrayObject &a);		// Copy constructor

    ~CNArrayObject();

    CNArrayObject &operator = (const CNArrayObject &a);
    

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_ARRAYOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_ARRAYOBJECT ? TRUE : CNArray::is_a(desc); }
        
    static CNArrayObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArrayObject *)obj;
#   else
	return (CNArrayObject *)( !obj || obj->is_a(CN_ARRAYOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAYOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNArrayObject(param) : new CNArrayObject; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__ArrayObject_h**/
