//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArrayChar  --- char array class
 *
 * Created from
 * $Id: T_array.cP,v 0.27 1995/01/20 15:14:47 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "ArrayChar.h"



/***** Private functions *****************************************************/

void CNArrayChar::init(int sz)
{
    asize = sz;
    array = new char[sz];
    for (int i = 0; i < sz; i++)
	array[i] = def_val;
}



void CNArrayChar::delete_array()
{
    asize = 0;
    if(array)
	delete [] array;
    array = NIL;
}



/***** Constructors **********************************************************/

CNArrayChar::CNArrayChar(int sz, char def)
{
    if (sz<0)
	fatal(NIL, "CNArrayChar: ", "invalid size < 0");
    
    def_val = def;
    init(sz);
}



CNArrayChar::CNArrayChar(const CNArrayChar &a)
{
    init(a.asize);
    for (int i = 0; i < asize; i++)
	array[i] = a.array[i];
}


CNArrayChar::~CNArrayChar()
{
    CNArrayChar::delete_array();
}



CNArrayChar &CNArrayChar::operator = (const CNArrayChar &a)
{
    delete_array();
    init(a.asize);
    for (int i = 0; i < asize; i++)
	array[i] = a.array[i];
    return *this;
}
    


/***** public functions ******************************************************/

void CNArrayChar::size(int sz)  // Set size of array
{
    if (sz<0)
	fatal(NIL, "CNArrayChar: ", "invalid size < 0");

    if (array == NIL)
	init(sz);
    else if (sz != asize)
    {
	char *temp = array;
	array = new char[sz];
	for (int i = 0; i < sz; i++)
	    if (i < asize)
		array[i] = temp[i];
	    else
		array[i] = def_val;
	delete[] temp;
	asize = sz;
    }
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNArrayChar::print(ostream &strm) const
{
    strm << "[ ";
    for(int i=0; i<asize; i++)
    {
	strm << array[i];
	if(i != asize-1)
	    strm << ", ";
    }
    strm << " ]";
}

// Debug output
void CNArrayChar::dump(ostream &strm) const
{
    strm << "CNArrayChar { $Revision: 0.27 $" << endl;
    strm << "size=" << asize
	 << " array=" << hex << (unsigned long)(array) << dec << endl;
    strm << "values=" << this << endl;
    strm << "}" << endl;
}



/***** CNCL stuff for type ***************************************************/

// Describing object for class CNArrayChar
static CNClass CNArrayChar_desc("CNArrayChar", "$Revision: 0.27 $",
			    CNArrayChar::new_object);

// "Type" for type checking functions
CNClassDesc CN_ARRAYCHAR = &CNArrayChar_desc;
