//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Moments.h,v 0.27 1995/01/20 15:13:27 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNMoments --- Simple stat. evaluation: mean, variance, skewness etc.
 *
 * Derived from SIC - Simulation In C++
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Moments_h
#define __Moments_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Statistics.h>		// Base class

extern CNClassDesc CN_MOMENTS;	// CNClass CNMoments description



/*
 * The class CNMoments
 */

class CNMoments : public CNStatistics
{
public:
    virtual void   put(register double x_i);
    virtual double mean() const;
    virtual void   reset();
    
    double variance()           const;
    double M_2()                const;
    double M_3()                const;
    double Z_3()                const;
    double relative_variance()  const;
    double deviation()          const;
    double relative_deviation() const;
    double skewness()           const;

    virtual unsigned long   trials() const { return n; }
    virtual double          max()    const { return max_value; }
    virtual double          min()    const { return min_value; }

    virtual bool            end()    const { return FALSE; } // 03.12.93 (fuss)
    virtual Phase           state()  const { return ITERATE; }
    virtual Phase           status() const { return ITERATE; }

    // Private members
private:
    char  *name;	// Name
    double sum ;	// Sum of all values
    double sqsum ;	// Sum of all values^2
    double cbsum ;	// Sum of all values^3
    long   n;		// # of values
    double min_value;	// Minimum of all values
    double max_value;	// Maximum of all values

    /***** Constructors ******************************************************/
public:
    CNMoments(char *new_name = "no name");
    CNMoments(CNParam *param) {}			// CNParam constructor
    ~CNMoments();
    
    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_MOMENTS;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_MOMENTS ? TRUE : CNStatistics::is_a(desc);
    };
        
    static CNMoments *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNMoments *)obj;
#   else
	return (CNMoments *)( obj->is_a(CN_MOMENTS)
	       ? obj : fatal_type(obj->class_desc(), CN_MOMENTS) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNMoments(param) : new CNMoments; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline void CNMoments::put(double x_i)
{
    double square = x_i * x_i;
    sum   += x_i;
    sqsum += square;
    cbsum += x_i * square;
    if (x_i > max_value)
	max_value = x_i;
    if (x_i < min_value)
	min_value = x_i;
    n++;
}


#endif /**__Moments_h**/
