//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MDeterm.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNMDeterm --- Mixed deterministic random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __MDeterm_h
#define __MDeterm_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_MDETERM;	// CNClass CNMDeterm description


/*
 * The class CNMDeterm
 */

class CNMDeterm : public CNRandom
{
protected:
    double mix;
    double det1, det2;

public:
    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNMDeterm();  				// Default constructor
    CNMDeterm(CNParam *param);  			// CNParam constructor
    CNMDeterm(double m, double d1, double d2, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_MDETERM;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_MDETERM ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNMDeterm *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNMDeterm *)obj;
#   else
	return (CNMDeterm *)( !obj || obj->is_a(CN_MDETERM)
	       ? obj : fatal_type(obj->class_desc(), CN_MDETERM) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNMDeterm(param) : new CNMDeterm; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNMDeterm::CNMDeterm(double m, double d1, double d2, CNRNG *gen)
    : CNRandom(gen)
{
    mix = m;
    assert((m>=0) && (m<=1));
    det1 = d1;
    det2 = d2;
}

inline CNMDeterm::CNMDeterm() : CNRandom ((CNRNG*)NIL)
{
    mix = 0;
    det1 = 0;
    det2 = 0;
}

inline CNMDeterm::CNMDeterm(CNParam *param) : CNRandom((CNRNG*)NIL)
{
    mix = 0;
    det1 = 0;
    det2 = 0;
}
					 
		       
#endif /**__MDeterm_h**/
