//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLObject.h,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDLObject --- Double linked object for CNDLList
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __DLObject_h
#define __DLObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_DLOBJECT;	// CNClass CNDLObject description



/*
 * The class CNDLObject
 */

class CNDLObject : public CNObject
{
    friend class CNDLList;
    
  public:
    // Set/get next pointer
    CNDLObject *next(CNDLObject *p)
    {
	pnext = p; return pnext;
    }
    CNDLObject *next()
    {
	return pnext;
    }
    CNDLObject *set_next(CNDLObject *p)
    {
	pnext = p; return pnext;
    }
    CNDLObject *get_next()
    {
	return pnext;
    }

    // Set/get prev pointer
    CNDLObject *prev(CNDLObject *p)
    {
	pprev = p; return pprev;
    }
    CNDLObject *prev()
    {
	return pprev;
    }
    CNDLObject *set_prev(CNDLObject *p)
    {
	pprev = p; return pprev;
    }
    CNDLObject *get_prev()
    {
	return pprev;
    }

    // Set/get object pointer
    CNObject *object(CNObject *o)
    {
	pobj = o; return pobj;
    }
    CNObject *object()
    {
	return pobj;
    }
    CNObject *set_object(CNObject *o)
    {
	pobj = o; return pobj;
    }
    CNObject *get_object()
    {
	return pobj;
    }

    // Delete object
    void delete_object()
    {
	delete pobj;
    }
    

    // Private members
  private:
    CNDLObject *pnext;
    CNDLObject *pprev;
    CNObject   *pobj;

  protected:
    // Only CNDLList and heirs of CNDLObject may delete CNDLObject's
    virtual ~CNDLObject() {}
    
    /***** Constructors ******************************************************/
  public:
    CNDLObject() : pnext(NIL), pprev(NIL), pobj(NIL) {}
    CNDLObject(CNObject *obj) : pnext(NIL), pprev(NIL), pobj(obj) {}
    CNDLObject(CNParam *param) : pnext(NIL), pprev(NIL), pobj(NIL) {}

  private:
    CNDLObject(const CNDLObject &link) : pnext(NIL), pprev(NIL), pobj(NIL)
    {
	fatal(NIL, "can't copy CNDLObject object");
    }

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_DLOBJECT;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_DLOBJECT ? TRUE : CNObject::is_a(desc);
    };
        
    static CNDLObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLObject *)obj;
#   else
	return (CNDLObject *)( !obj || obj->is_a(CN_DLOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_DLOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDLObject(param) : new CNDLObject; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__DLObject_h**/
