//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArray2Object  --- CNObjPtr array class
 *
 * Created from
 * $Id: T_array2.hP,v 0.27 1995/01/20 15:14:47 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Array2Object_h
#define __Array2Object_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Array2.h>
#include <CNCL/ArrayObject.h>

extern CNClassDesc CN_ARRAY2OBJECT;	// CNClass CNArray2Object description


/*
 * The class CNArray2Object
 */

typedef CNObject *CNObjPtr;

class CNArray2Object : public CNArray2
{
  public:	/***** Public interface **************************************/
    virtual void size(int r, int c);

    void put(int r, int c, CNObjPtr value)// Put value into array
    {
#   ifndef NO_RANGE_CHECK
	if(r<0 || arows<=r || c<0 || acols<=c)
	    range_error(r, c);
	else
#   endif
	    array[r][c] = value;
    }

    CNObjPtr get(int r, int c) const	// Get value from array
    {
#   ifndef NO_RANGE_CHECK
	if(r<0 || arows<=r || c<0 || acols<=c)
	{   range_error(r, c); return 0; }
	else
#   endif
	    return array[r][c];
    }

    CNArrayObject& operator[] (int index)	// Operator []
    {
#   ifndef NO_RANGE_CHECK
	if (index<0 || arows<=index)
	    range_error(index);
#   endif
	return array[index];
    }

  private:	/***** Internal private members ******************************/
    CNArrayObject *array;		// Array of array of CNObjPtr
    CNObjPtr def_val;			// Default value
    
    void init(int r, int c);		// Initialize array
    void delete_array();                // Delete array

  public:	/***** Constructors ******************************************/
    CNArray2Object()               : CNArray2(0,0), array(NIL), def_val(0) {}
    CNArray2Object(CNParam *param) : CNArray2(0,0), array(NIL), def_val(0) {}
    CNArray2Object(int r, int c, CNObjPtr def=0);
    CNArray2Object(const CNArray2Object &a);		// Copy constructor

    ~CNArray2Object();

    CNArray2Object &operator = (const CNArray2Object &a);
    

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_ARRAY2OBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_ARRAY2OBJECT ? TRUE : CNArray2::is_a(desc); }
        
    static CNArray2Object *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArray2Object *)obj;
#   else
	return (CNArray2Object *)( !obj || obj->is_a(CN_ARRAY2OBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAY2OBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNArray2Object(param) : new CNArray2Object; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__Array2Object_h**/
