//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: config.h,v 0.27 1995/01/20 15:16:00 cncl-adm Exp cncl-adm $
 *
 * CNCL operating system/compiler configuration header file
 *
 *****************************************************************************
 * Copyright (C) 1992-1994   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CONFIG_H
#define __CONFIG_H

// 
// *** UNCOMMENT THE DEFINES BELOW, IF THE AUTO DETECTION DOESN'T WORK ***
//

/*
 * Operating system
 */
/* SunOS 4.1.x */
// #define CNCL_SYS_SUNOS41	1
/* Solaris 2.x */
// #define CNCL_SYS_SOLARIS2	1
/* Generic SysVR4 */
// #define CNCL_SYS_SVR4	1
/* HP/UX */
// #define CNCL_SYS_HPUX	1
/* AIX */
// #define CNCL_SYS_AIX		1
/* LINUX */
// #define CNCL_SYS_LINUX	1
/* Ultrix */
// #define CNCL_SYS_ULTRIX	1
/* MSDOS */
// #define CNCL_SYS_MSDOS	1
/* Amiga */
// #define CNCL_SYS_AMIGA	1


/*
 * Compiler
 */
/* GCC 2 */
// #define CNCL_CC_GCC2		1
/* GCC 2.5.x */
// #define CNCL_CC_GCC25	1
/* GCC 2.6.x */
// #define CNCL_CC_GCC26	1
/* Borland C++ */
// #define CNCL_CC_BCC		1


/*
 * C++
 */
/* Builtin data type `bool' */
// #define CNCL_HAS_BOOL	1


/*
 * Libraries
 */
/* No matherr() available */
// #define CNCL_NO_MATHERR	1


//
// *** Auto detection ***
//
/* OS */
#if defined(__svr4__) || defined(SVR4)
# define CNCL_SYS_SVR4	1
#endif

#ifdef __sun__
# ifdef CNCL_SYS_SVR4
#  define CNCL_SYS_SOLARIS2	1
# else
#  define CNCL_SYS_SUNOS41	1
# endif
#endif

#ifdef __hpux
# define CNCL_SYS_HPUX		1
#endif

#ifdef __linux__
# define CNCL_SYS_LINUX		1
#endif

#ifdef __ultrix
# define CNCL_SYS_ULTRIX	1
#endif

#ifdef MSDOS
# define CNCL_SYS_MSDOS		1
#endif

#ifdef __amiga__
# define CNCL_SYS_AMIGA		1
#endif

/* Compiler */
#if __GNUC__ == 2
# define CNCL_CC_GCC2		1
# if __GNUC_MINOR__ >= 6
#  define CNCL_CC_GCC26		1
# endif
# if __GNUC_MINOR__ <= 5
#  define CNCL_CC_GCC25		1
# endif
#endif

/* C++ */
#ifdef CNCL_CC_GCC26
# define CNCL_HAS_BOOL		1
#endif

/* Libraries */
#if defined(CNCL_SYS_LINUX) || defined(CNCL_SYS_AMIGA)
# define CNCL_NO_MATHERR	1
#endif


#endif /**__CONFIG_H**/
