/* -*-text-*-
 *
 * Fuzzy Rules Compiler
 *
 * $Id: fuzzylex.l,v 0.27 1995/01/20 15:13:18 cncl-adm Exp cncl-adm $
 *
 * fuzzylex.l - fuzzy rules lexical scanner (GNU flex)
 */

/* C definitions */
%{
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "fuzzyparse.h"


int lexline = 1;
%}

NUMERIC ([0-9])
ALPHA   ([A-Za-z_])
ALNUM   ({ALPHA}|{NUMERIC})

/* Patterns */
%%
"rulebase"	return(Krulebase);
"set"		return(Kset);
"trapez"	return(Ktrapez);
"triangle"	return(Ktriangle);
"var"		return(Kvar);
"if"		return(Kif);
"and"		return(Kand);
"&&"		return(Kand);
"is"		return(Kis);
"="		return(Kis);
"=="		return(Kis);
"certainty"	return(Kcertainty);

{ALPHA}{ALNUM}*	{
			yylval.id = yytext;
			return(Identifier);
		}

-?{NUMERIC}+(\.{NUMERIC}*)? |
-?\.{NUMERIC}+	{
			yylval.num = strtod(yytext, NULL);
			return(Number);
		}

[ \t]+		;

\/\/.*		;

\n		lexline++;

.		return(yytext[0]);
