//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLManager.h,v 0.27 1995/01/20 15:15:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLManager --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNSDLManager_h
#define __CNSDLManager_h

/*
   The class SDLManager was first designed to handle only the comunication
   of SDL-Processes. Later it took much more functionality. Nearly all basic
   SDL functions are provided by this class. There is also a simple method
   to handle dynamic SDL included. This class uses SDLTimer and SDLProcess-
   Data as service providers although these classes won't work without the
   SDLManager class. 
*/

class CNSDLProcess;
class CNSDLProcessData;

 
#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EventHandler.h>		// Base class

#include <CNCL/DLObject.h>

#include <CNCL/Int.h>        // Standard Datatypes for SDL
#include <CNCL/Double.h>

#include <CNCL/SDLSignal.h>
#include <CNCL/SDLProcessData.h>
#include <CNCL/SDLProcess.h>
#include <CNCL/SDLChannel.h>

extern CNClassDesc CN_SDLMANAGER;	// Class CNSDLManager description


typedef int PId;
typedef int TimerType;
typedef int SignalType;
typedef int ChannelNo;
typedef int ProcessType;


        
/*
 * The class CNSDLManager
 */

class CNSDLManager : public CNEventHandler
{
  friend class CNSDLEnvironment;
  
  
  public:
    void save(int = 0);  // the SDL save construct
    
    void create(CNSDLProcess*, PId = 0);  // creates new process
    void stop();                          // kills process
    
    void set(CNSimTime, TimerType);  // handling timers
    void reset(TimerType);
    bool active(TimerType);
    void remove(TimerType);
    
    // send signals in block (explicit, implicit, via signalroute)
    virtual void output_x(SignalType, PId, CNObject* = NIL);          
    virtual void output(SignalType, CNObject* = NIL);                 
    virtual void output(SignalType, ProcessType, CNObject* = NIL);
    
    // send between blocks (explicit, signalroute)
    virtual void output_x(SignalType, PId, CNSDLChannel*, 
                          CNObject* = NIL, int do_not_use = 0);
    virtual void output(SignalType, ProcessType, CNSDLChannel*, 
                        CNObject* = NIL, int do_not_use = 0);
    
    CNObject *get_data();    // get data attached to signal
    int get_source_system(); // get sending SDL system 
    
    CNSDLChannel *channel(ChannelNo);       // get channel
    
    CNSimTime now();    // actual simulation time
    
    CNEventBaseSched *scheduler();  // is protected but needed in SDLProcesses
    virtual CNSDLManager *S(int);   // is used by environment only
    
  
  protected:
    virtual void event_handler(const CNEvent*); 
                            // this one does the communication
  
    
  private:
    int system;    // who am i?
        
    PId actual_process;            // the actual process
    CNSDLProcess *that;            // and its memory address
    CNSDLProcessData *thatdata;
    
    CNSDLSignal *signal;  // signal delivered
    
    bool has_saved;       // internal variables
    bool in_save_list;

    CNEventBaseSched *sched;
  

  protected:
    CNSDLProcessData **processes;  // array of process data (created in
                                   // derived classes)
    long pr_size;                  // size of above
    
    ProcessType *signal_receiver; // array of default recipients of a given
                        // signal (created and initialized in derived classes)
    long sr_size;       // size of above
    
    CNSDLChannel **channels;  // array of SDL channels (created and
                              // initialized in derived classes)
    long ch_size;             // size of above        


    /***** Constructors ******************************************************/
  public:
    CNSDLManager(CNParam *param) {}	// CNParam constructor
    CNSDLManager(int, CNEventBaseSched*);  // this one will be used
  
    ~CNSDLManager();
    
    
  protected:    
    CNSDLManager() {}			// Default constructor
   
   
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SDLMANAGER;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SDLMANAGER ? TRUE : CNEventHandler::is_a(desc);
    };
        
    static CNSDLManager *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNSDLManager *)obj;
#   else
        return (CNSDLManager *)( !obj || obj->is_a(CN_SDLMANAGER)
               ? obj : fatal_type(obj->class_desc(), CN_SDLMANAGER) );
#   endif
    }
      
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



// now the inlines

// access data attached to signal (SDLManager transfers only the name of the
// signal by default. Usually this is enough)
inline CNObject *CNSDLManager::get_data() { return signal->object(); }

inline int CNSDLManager::get_source_system() { return signal->system(); }

inline CNSDLChannel *CNSDLManager::channel(ChannelNo cn)
{
    return channels[cn];
}

// get actual simulation time
inline CNSimTime CNSDLManager::now() { return CNEventHandler::now(); }

// get scheduler
inline CNEventBaseSched *CNSDLManager::scheduler() { return sched; }


#endif /**__CNSDLManager_h**/
