// *BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ReaderTbl.h,v 0.27 1995/01/20 15:14:52 cncl-adm Exp cncl-adm $
 *
 * Class: CNReaderTbl --- Table for adress of reader-function (persistent IO)
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNReaderTbl_h
#define __CNReaderTbl_h

#include <CNCL/String.h>
#include <iostream.h>
#include <CNCL/HashDynamic.h>
#include <CNCL/KeyInt.h>
#include <CNCL/KeyString.h>

typedef CNObject*(*Reader_ptr)(CNPstream&);	// type reader-function-pointer 
class CNReaderTbl : public CNCL 
{
private:
    static CNHashDynamic table;	       // reader-function-pointer table
    static CNHashDynamic id_table;     // id-object tble

public:
   CNReaderTbl(char*, Reader_ptr);	// constructor performing table entry
   ~CNReaderTbl() {}			// destructor
   static Reader_ptr reader_ptr_by_classname(char*);	

   static bool is_in(long);
   static void add_to_id_tbl(long, CNObject*);
   static void add_to_id_tbl(long, CNObject&);
   static CNObject* get_from_id_tbl(long);
   static void reset_id_tbl();
   
   
};

#endif

