//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: HashTable.h,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNHashTable --- Abstract base class for hash tables
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __HashTable_h
#define __HashTable_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_HASHTABLE;	// CNClass CNHashTable description

#include <CNCL/Key.h>

const unsigned long DEFAULT_HASH_TABLE_CAPACITY = 101;

/*
 * The class CNHashTable
 */

struct HashEntry {
    CNKey *he_CNKey;
    unsigned long he_HashValue;
};

class CNHashIterator;

class CNHashTable : public CNObject
{
protected:
    friend class CNHashIterator;
    virtual struct HashEntry *HashTable() const = 0;
public:
    virtual void store_key(CNKey *k) = 0;
    virtual void store_key(CNKey &k) = 0;
    
    virtual CNKey *get_key(CNKey *k) const = 0;
    virtual CNKey *get_key(CNKey &k) const = 0;
        
    virtual CNObject *get_object(CNKey *k) const = 0;
    virtual CNObject *get_object(CNKey &k) const = 0;
        
    virtual bool reset() = 0;
    virtual bool reset_absolutely() = 0;
    virtual bool delete_key(CNKey *k) = 0;
    virtual bool delete_key(CNKey &k) 
    { return delete_key(&k); }
    virtual bool delete_key_absolutely(CNKey *k) = 0;
    virtual bool delete_key_absolutely(CNKey &k) = 0;
        
    virtual bool is_full() const = 0;
    virtual bool is_empty() const = 0;
    virtual unsigned long get_capacity() const = 0;
    virtual unsigned long get_num_entries() const = 0;
        
    /***** Constructors ******************************************************/
public:
    CNHashTable() {}				// Default constructor
    CNHashTable(CNParam *param) {}			// CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_HASHTABLE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_HASHTABLE ? TRUE : CNObject::is_a(desc);
    };
        
    static CNHashTable *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNHashTable *)obj;
#   else
	return (CNHashTable *)( !obj || obj->is_a(CN_HASHTABLE)
	       ? obj : fatal_type(obj->class_desc(), CN_HASHTABLE) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};

#endif /**__HashTable_h**/
