//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Beta.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNBeta --- CNBeta distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Beta_h
#define __Beta_h 


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_BETA;	// CNClass CNBeta description



/*
 * The class CNBeta
 */

class CNBeta : public CNRandom
{
protected:
    long pr1, pr2;

public:
    virtual double operator()() ;

    /***** Constructors ******************************************************/
public:
    CNBeta() ;				// Default constructor
    CNBeta(CNParam *param) ;  		// CNParam constructor
    CNBeta(long a, long b, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_BETA;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_BETA ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNBeta *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNBeta *)obj;
#   else
	return (CNBeta *)( !obj || obj->is_a(CN_BETA)
	       ? obj : fatal_type(obj->class_desc(), CN_BETA) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNBeta(param) : new CNBeta; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


inline CNBeta::CNBeta(long a, long b, CNRNG *gen) : CNRandom(gen)
{
    assert((a>=0) && (b>=0) && ((a!=0) || (b!=0)));
    pr1 = a;
    pr2 = b;
}

inline CNBeta::CNBeta () : CNRandom((CNRNG*)NIL)
{
    pr1 = 0;
    pr2 = 0;
}


inline CNBeta::CNBeta (CNParam *param) : CNRandom((CNRNG*)NIL)
{
    pr1 = 0;
    pr2 = 0;
}

#endif /**__Beta_h**/
