//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: HashIterator.h,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * Class: CNHashIterator --- hash table sequential iterator
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNHashIterator_h
#define __CNHashIterator_h


#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_HASHITERATOR;	// Class CNHashIterator description

#include <CNCL/HashTable.h>


/*
 * The class CNHashIterator
 */

class CNHashIterator : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNHashIterator() : hash_table(NIL), index(0) {}
    CNHashIterator(CNParam *) : hash_table(NIL), index (0) {}
    CNHashIterator(const CNHashTable *new_hash_table)
    {
	reset(new_hash_table);
    }
    CNHashIterator(const CNHashTable &new_hash_table)
    {
	reset(new_hash_table);
    }
    
  public:	/***** Public interface **************************************/
    void reset(const CNHashTable *new_hash_table)
    {
	hash_table = new_hash_table;
	reset();
    }
    void reset(const CNHashTable &new_hash_table)
    {
	hash_table = &new_hash_table;
	reset();
    }
    void reset()
    {
	index = 0;
    }

    // Get key from indexed position
    CNKey *get_key()
    {
	if (hash_table && index >= 0)
	{
	    HashEntry *entries = hash_table->HashTable();
	    
	    for (; index < hash_table->get_capacity(); index++)
		if (entries[index].he_CNKey)
		    return entries[index].he_CNKey;
	}
	return NIL;
    }
    CNKey *key()
    {
	return get_key();
    }

    // Move to first entry, retrieve current key
    CNKey *first_key()
    {
	index = 0;
	return get_key();
    }
    CNKey *first()
    {
	return first_key();
    }

    // Move to last entry, retrieve current key
    CNKey *last_key()
    {
	if (hash_table)
	{
	    CNKey *k;
	    
	    index = hash_table->get_capacity() - 1;
	    if (k = prev_key())
		index++;
	    return k;
	}
	return NIL;
    }
    CNKey *last()
    {
	return last_key();
    }
    	    
    // Advance to next entry, retrieve current key
    CNKey *next_key()
    {
	if (hash_table)
	{
	    CNKey *k = get_key();
	    index++;
	    return k;
	}
	return NIL;
    }
    CNKey *next()
    {
	return next_key();
    }
    CNKey *operator++()		// Prefix ++arg
    {
	return next_key();
    }
    CNKey *operator++(int)	// Postfix arg++ (C++ 3.0)
    {
	return next_key();
    }

    // Move to previous entry, retrieve current key
    CNKey *prev_key()
    {
	if (hash_table && index < hash_table->get_capacity())
	{
	    HashEntry *entries = hash_table->HashTable();
	    
	    for (; index >= 0; index--)
		if (entries[index].he_CNKey)
		{
		    CNKey *k = entries[index].he_CNKey;
		    index--;
		    return k;
		}
	    index = 0;
	}
	return NIL;
    }
    CNKey *prev()
    {
	return prev_key();
    }
    CNKey *operator--()		// Prefix --arg
    {
	return prev_key();
    }
    CNKey *operator--(int)	// Postfix arg-- (C++ 3.0)
    {
	return prev_key();
    }

    // Get object from indexed position
    CNObject *get_object()
    {
	CNKey *k;
	
	return (k = get_key()) ? k->get_object() : NIL;
    }
    CNObject *object()
    {
	return get_object();
    }

    // Move to first entry, retrieve current object
    CNObject *first_object()
    {
	CNKey *k;
	
	return (k = first_key()) ? k->get_object() : NIL;
    }
    	    
    // Move to last entry, retrieve current object
    CNObject *last_object()
    {
	CNKey *k;
	
	return (k = last_key()) ? k->get_object() : NIL;
    }
    	    
    // Advance to next entry, retrieve current object
    CNObject *next_object()
    {
	CNKey *k;
	
	return (k = next_key()) ? k->get_object() : NIL;
    }

    // Move to previous entry, retrieve current object
    CNObject *prev_object()
    {
	CNKey *k;
	
	return (k = prev_key()) ? k->get_object() : NIL;
    }

  private:	/***** Internal private members ******************************/
    const long RESET_ITERATOR = -1;
    
    const CNHashTable *hash_table;
    long index;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_HASHITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_HASHITERATOR ? TRUE : CNObject::is_a(desc); }
        
    static CNHashIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNHashIterator *)obj;
#   else
	return (CNHashIterator *)( !obj || obj->is_a(CN_HASHITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_HASHITERATOR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNHashIterator(param) : new CNHashIterator; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNHashIterator &obj);
ostream &operator << (ostream &strm, const CNHashIterator *obj);

#endif /**__CNHashIterator_h**/
