//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: AVLNode.h,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * Class: CNAVLNode --- Node for CNAVLTree
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __CNAVLNode_h
#define __CNAVLNode_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_AVLNODE;	// Class CNAVLNode description


/*
 * The class CNAVLNode
 */

class CNAVLNode : public CNObject
{
    friend class CNAVLTree;
    
  public:
    CNAVLNode();		       	// Default constructor
    CNAVLNode(CNParam *param);		// CNParam constructor
    virtual ~CNAVLNode();
    
  public:       /***** Public interface **************************************/
    virtual int compare(CNAVLNode*) = 0; // compare node with another one
    virtual int find(CNAVLTree*) = 0;    // compare node with searched key
    CNAVLNode *left() { return l; };
    CNAVLNode *right() { return r; };

  private:	/***** Internal private members ******************************/
    CNAVLNode *l,*r;
    short bal;
    virtual void print_tree(ostream &strm, int depth) const;
    virtual void dump_tree (ostream &strm, int depth) const;
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_AVLNODE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_AVLNODE ? TRUE : CNObject::is_a(desc); }
        
    static CNAVLNode *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNAVLNode *)obj;
#   else
	return (CNAVLNode *)( !obj || obj->is_a(CN_AVLNODE)
	       ? obj : fatal_type(obj->class_desc(), CN_AVLNODE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { 
	fatal("Cannot create object of abstract class AVLNode");
	return NIL; 
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNAVLNode_h**/


