//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ACG.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNACG --- Additive random number generator
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *   written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 *
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/


#ifndef __ACG_h
#define __ACG_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/RNG.h>		// Base class

extern CNClassDesc CN_ACG;	// CNClass CNACG description


//
//  Additive number generator. This method is presented in Volume II
//  of The Art of Computer Programming by Knuth. I've coded the algorithm
//  and have added the extensions by Andres Nowatzyk of CMU to randomize
//  the result of algorithm M a bit by using an CNLCG & a spatial
//  permutation table.
//
//  The version presented uses the same constants for the CNLCG that Andres
//  uses (chosen by trial & error). The spatial permutation table is
//  the same size (it's based on word size). This is for 32-bit words.
//
//  The ``auxillary table'' used by the CNLCG table varies in size, and
//  is chosen to be the the smallest power of two which is larger than
//  twice the size of the state table.
//


/*
 * The class CNACG
 */

class CNACG : public CNRNG
{
public:
    virtual unsigned long as_long32();
    virtual void reset();
    virtual bool has_long32() {return TRUE;}
    
    // Private members
private:
    unsigned long initialSeed;  // used to reset generator
    int initialCNTableEntry;

    unsigned long *state;
    unsigned long *auxState;
    short stateSize;
    short auxSize;
    unsigned long lcgRecurr;
    short j;
    short k;

    /***** Constructors ******************************************************/
public:
    CNACG(unsigned long seed = 0, int size = 55);
    virtual ~CNACG();
    CNACG(CNParam *param) {}			// CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_ACG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_ACG ? TRUE : CNRNG::is_a(desc);
    };
        
    static CNACG *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNACG *)obj;
#   else
	return (CNACG *)( !obj || obj->is_a(CN_ACG)
	       ? obj : fatal_type(obj->class_desc(), CN_ACG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNACG(param) : new CNACG; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__ACG_h**/
