//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: SDLProcess_Environment --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __SDLProcess_environment_h
#define __SDLProcess_environment_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/SDLProcess.h>	// Base class

#include <CNCL/ACG.h>       // for random delays
#include <CNCL/Uniform.h>
#include <CNCL/QueueFIFO.h>

#include "SDLEnvironment_Signals.h"
#include "SDLSystem_DemonGame_Signals.h"
#include "SDLSystem_DemonGame_Channels.h"


extern CNClassDesc CN_SDLPROCESS_ENVIRONMENT;	// Class SDLProcess_environment description


/*
 * The class SDLProcess_environment
 */

class SDLProcess_environment : public CNSDLProcess
{
  public:	/***** Constructors ******************************************/
    SDLProcess_environment() {}                         // Default constructor
    SDLProcess_environment(CNParam *param) {}		// CNParam constructor
    
    SDLProcess_environment(char*, CNSDLManager*, int);
    
  public:	/***** Public interface **************************************/
    int process(int);         

  private:	/***** Internal private members ******************************/
    enum Timer {Wait = End_of_DemonGame_Signallist+1};
    
    CNRandom *rnd;
    char input;
    
    CNInt *score;
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SDLPROCESS_ENVIRONMENT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SDLPROCESS_ENVIRONMENT ? TRUE : CNSDLProcess::is_a(desc); }
        
    static SDLProcess_environment *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (SDLProcess_environment *)obj;
#   else
	return (SDLProcess_environment *)( obj->is_a(CN_SDLPROCESS_ENVIRONMENT)
	       ? obj : fatal_type(obj->class_desc(), CN_SDLPROCESS_ENVIRONMENT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new SDLProcess_environment(param) : new SDLProcess_environment; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__SDLProcess_environment_h**/
