//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: SDLProcess_Environment --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "SDLProcess_environment.h"


SDLProcess_environment::SDLProcess_environment(char *name, CNSDLManager *SM,
int ptype):CNSDLProcess(name, SM, ptype)
{
    CNRNG *base = new CNACG;
    rnd = new CNUniform(0.5, 2.5, base);
}




int SDLProcess_environment::process(int signal)
{
    switch( signal ) {
    case DemonGame_INIT:
        System->set( now()+0.1, Wait );
        return 0;
    case Win: 
        cout << "Won" << endl;
        return 0;
    case Lose: 
        cout << "Lost" << endl;
        return 0;
    case Score:
        CNQueueFIFO *queue = (CNQueueFIFO *) System->get_data();
        score = (CNInt*) queue->get();
        delete queue;
        cout << "Score: " << *score << endl;
        delete score;
        return 0;
    case Wait:
        System->remove( Wait );
        cout << "(N)ewgame, (E)ndgame, (P)robe, (R)esult, (W)ait" << endl;
        cout << "Your choice: "; cin >> input; cout << endl;
        switch( input ) {
        case 'n': case 'N':
            System->output( Newgame, 2, System->S(2)->channel(C1), NIL, 2 );
            break;
        case 'e': case 'E':
            System->output( Endgame, 2, System->S(2)->channel(C1), NIL, 2 );
            break;
        case 'p': case 'P':
            System->output( Probe, 3, System->S(2)->channel(C1), NIL, 2 );
            break;
        case 'r': case 'R':
            System->output( Result, 3, System->S(2)->channel(C1), NIL, 2 );
            break;
        }
        System->set( now()+rnd->draw(), Wait );
        return 0;
    default:
        return 0;
    }
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void SDLProcess_environment::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void SDLProcess_environment::dump(ostream &strm) const
{
    strm << "SDLProcess_environment { $Revision$ ..."
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class SDLProcess_Environment
static CNClass SDLProcess_environment_desc("SDLProcess_environment", "$Revision$",
			    SDLProcess_environment::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESS_ENVIRONMENT = &SDLProcess_environment_desc;
