#include "SDLProcess_Main.h"

SDLProcess_Main::SDLProcess_Main(char *name,CNSDLManager *system, int process_type):CNSDLProcess(name, system, process_type)
{
}


virtual int SDLProcess_Main::process(int signal)
{
	switch(state()){

	case INIT:
				state(Game_Off);
				return 0;

	case Game_Off: switch(signal) {

				case Newgame:
				System->create(new SDLProcess_Game("Game", System, 3));
				GameP = offspring();
				state(Game_On);
				return 0;

				default:
					return 0;
			}

	case Game_On: switch(signal) {

				case Endgame:
				{
					System->output(GameOver, 3);
				}
				GameP = NIL;
				state(Game_Off);
				return 0;


				default:
					return 0;
			}
	default:
		error("illegal state");
			return 0;
	}
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void SDLProcess_Main::print(ostream &strm) const
{
	strm << "..." << endl;
}

// Debug output
void SDLProcess_Main::dump(ostream &strm) const
{
	strm << "SDLProcess_Main { $Revision: 1.25 $ ..."
	<< " }" << endl;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class SDLProcess_Main
static CNClass SDLProcess_Main_desc("SDLProcess_Main", "$Revision: 1.25 $",
			SDLProcess_Main::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESS_Main = &SDLProcess_Main_desc;