#include "SDLProcess_Game.h"

SDLProcess_Game::SDLProcess_Game(char *name,CNSDLManager *system, int process_type):CNSDLProcess(name, system, process_type)
{
}


virtual int SDLProcess_Game::process(int signal)
{
	switch(state()){

	case INIT:
				Count = 0;
				state(Losing);
				return 0;

	case Losing: switch(signal) {

				case Probe:
				{
					System->output(Lose, 1, System->channel(C2));
				}
				Count = Count - 1;
				state(Losing);
				return 0;

				case Bump:
				state(Winning);
				return 0;
				case Result:
				{
					CNQueueFIFO *cnqueue_fifo = new CNQueueFIFO;

					cnqueue_fifo->put(new CNInt(Count));
					System->output(Score, 1, System->channel(C2), cnqueue_fifo);
				}
				state(state());
				return 0;

				case GameOver:
				System->stop();
				return 0;

				default:
					return 0;
			}

	case Winning: switch(signal) {

				case Bump:
				state(Losing);
				return 0;

				case Probe:
				{
					System->output(Win, 1, System->channel(C2));
				}
				Count = Count+1;
				state(Winning);
				return 0;
				case Result:
				{
					CNQueueFIFO *cnqueue_fifo = new CNQueueFIFO;

					cnqueue_fifo->put(new CNInt(Count));
					System->output(Score, 1, System->channel(C2), cnqueue_fifo);
				}
				state(state());
				return 0;

				case GameOver:
				System->stop();
				return 0;


				default:
					return 0;
			}
	default:
		error("illegal state");
			return 0;
	}
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void SDLProcess_Game::print(ostream &strm) const
{
	strm << "..." << endl;
}

// Debug output
void SDLProcess_Game::dump(ostream &strm) const
{
	strm << "SDLProcess_Game { $Revision: 1.25 $ ..."
	<< " }" << endl;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class SDLProcess_Game
static CNClass SDLProcess_Game_desc("SDLProcess_Game", "$Revision: 1.25 $",
			SDLProcess_Game::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESS_Game = &SDLProcess_Game_desc;