// -*- C++ -*-

// Example program 'indoor' for the new GIST-Interface

// This example shows how to use some of the possibilities of
// the class GISTPicture

#include <CNCL/gist.h>

main (int argc, char ** argv) {

// first of all do a little communication
   Comm comm;

// then create a world for the objects and set the starttime
   double simtime = 5.0;
   GISTWorld world(comm, "Indoor-World", 0, 100, 0, 80, simtime);

// create a new GISTObject 'Building'
   GISTObject *building = new GISTObject(world, "Building");

// create a GISTTextAttribute for the visibility of the building
   GISTTextAttribute *building_visible = 
            new GISTTextAttribute(building, "Building_Visible");

// turn on the visibility of the building
   building_visible->put(simtime, "on");

// create a GISTPicture to draw the indoor-scenario
   GISTPicture *scenario = new GISTPicture(building, "Indoor-Scenario", 1);

// then we draw the scenario

// set the brush and a color for the outer walls
   scenario->set_brush(3.0);
   scenario->set_color("blue");

// set startpoint to draw and move the 'pen' down to start drawing
   scenario->set_pos(10, 10);
   scenario->pen_down();

// draw with absolut coordinates
   scenario->set_pos(90, 10);
   scenario->set_pos(90, 70);
   scenario->set_pos(10, 70);
   scenario->set_pos(10, 10);
   scenario->pen_up();

// set a new brush and color to draw the rooms
   scenario->set_brush(1.5);
   scenario->set_color("green");

   scenario->set_pos(10, 25);
   scenario->pen_down();
   scenario->set_pos(25, 25);

// draw an open door
   scenario->pen_up();

   scenario->set_pos(30, 25);
   scenario->pen_down();
   scenario->set_pos(40, 25);
   scenario->set_pos(40, 10);
   scenario->pen_up();

// draw the next rooms
   scenario->set_pos(40, 25);
   scenario->pen_down();
   scenario->set_pos(90, 25);
   scenario->pen_up();

   scenario->set_pos(10, 35);
   scenario->pen_down();
   scenario->set_pos(60, 35);
   scenario->set_pos(60, 70);
   scenario->pen_up();

   scenario->set_pos(60, 35);
   scenario->pen_down();
   scenario->set_pos(90, 35);
   scenario->pen_up();


// now we create another GISTObject handy
   GISTObject *handy = new GISTObject(world, "Handy");

// define some attributes

// attribute for moving the handy around
   GISTCoordAttribute *position = new GISTCoordAttribute (handy, "Position");

// put the handy at the position (27,20) at starttime
   position->put(simtime, 27, 20);

// attribute for the visibility of the handy
   GISTTextAttribute *visible = new GISTTextAttribute (handy, "Visible");

// turn visibility on
   visible->put(simtime, "on");

// atribute for the look of the handy
   GISTTextAttribute *look = new GISTTextAttribute(handy, "Look");

// chose the tiff-picture 'handh' for the image
   look->put(simtime, "handh");

// create image of the object 'car'
   GISTImage *handy_image = new GISTImage (handy, "Handy_Image", look, position, 4, 8, 0.5, 0.5, 2, visible);


// now the user can start his application
// ...

// some examples: 

// move handy around
   for (int y=12; y<31; y+=1) {
      position->put(simtime++, 27, y);
   };

// stay some time at that place
   simtime+=10;

// then move on
   for (int x=27; x<81;x+=2) {
      position->put(simtime++, x, 30);
   };


// etc.

// delete the GISTObjects
// Remember: you must not delete all the GISTAttributes, GISTImages or
// GISTPictures of a GISTObject on your own! The GISTObject will care
// about deleting them within its destructor.
   delete handy;
   delete building;
}
