-------------------------------------------------------------------------------
--                                                                           --
--               Ada95 Bindings to Linux SVGA Library                        --
--                                                                           --
--                         Darren J Moffat                                   --
--                      moffatd@dcs.gla.ac.uk                                --
--                                                                           --
-- These bindings may be distributed under the same agreement as holds for   --
-- the current version of SVGALib.  With the additional condition that my    --
-- name must not be removed from any of the Ada source files.                --
--                                                                           --
-------------------------------------------------------------------------------
-- Last Modified: 
-- $RCSfile: svgalibmouse.ads,v $
-- $Revision: 1.1 $
-- $Author: djm $
-- $Log: svgalibmouse.ads,v $
-- Revision 1.1  1995/02/08  00:57:42  djm
-- entered into RCS
--
 
with
  Interfaces.C,
  SVGALib;
use 
  Interfaces.C,
  SVGALib;

package SVGALibMouse is


   Mouse_Error : exception;

   ----------------------------------------------------------------------
   -- Mouse Types
   ----------------------------------------------------------------------

   type MouseType is (Microsoft, MouseSystems, MMSeries,
		      Logitech, BusMouse, PS2);
   for MouseType'Size use Int'Size;
   for MouseType use (Microsoft => 0, MouseSystems => 1, MMSeries => 2,
		      Logitech => 3, BusMouse => 4, PS2 => 5);

   type MouseButton is (Right, Middle, Dummy, Left);
   for MouseButton'Size use Int'Size;
   for MouseButton use (Right => 1, Middle => 2, Dummy => 3, Left => 4);

   Default_Sample_Rate : constant Integer := 150;


   ----------------------------------------------------------------------
   -- Administravia
   ----------------------------------------------------------------------

   procedure Mouse_Init (MT : MouseType := Microsoft;
			 Device : String := "/dev/mouse";
			 Rate : Integer := Default_Sample_Rate);

   function Mouse_Close return Boolean;
   pragma Import (C, Mouse_Close, "mouse_close");


   ----------------------------------------------------------------------
   -- Event Handlers
   ----------------------------------------------------------------------
   
--   procedure Set_Event_Handler ( ???? );
--   pragma Import (C, Set_Event_Handler, "mouse_setevent_handler");

   procedure Set_Default_Event_Handler;
   pragma Import (C, Set_Default_Event_Handler,"mouse_setdefaulteventhandler");

   function Mouse_Update return Boolean;
   pragma Import (C, Mouse_Update, "mouse_update");

   procedure Mouse_Wait_For_Update;
   pragma Import (C, Mouse_Wait_For_Update, "mouse_waitforupdate");


   ----------------------------------------------------------------------
   -- Status Functions
   ----------------------------------------------------------------------
   
   procedure Mouse_Set_Position (P : Point);
   
   function Mouse_Get_Position return Point;

   function Mouse_Get_Button return MouseButton;
   pragma Import (C, Mouse_Get_Button, "mouse_getbutton");

   procedure Mouse_Set_XRange (X1, X2 : Integer);
   pragma Import (C, Mouse_Set_XRange, "mouse_setxrange");

   procedure Mouse_Set_YRange (Y1, Y2 : Integer);
   pragma Import (C, Mouse_Set_YRange, "mouse_setyrange");

   procedure Mouse_Set_Scale (S : Integer);
   pragma Import (C, Mouse_Set_Scale, "mouse_setscale");


   type WrapMode is (NoWrap, WrapX, WrapY, WrapBoth);
   for WrapMode'Size use Int'Size;
   for WrapMode use (NoWrap => 0, WrapX => 1, WrapY => 2, WrapBoth => 3);

   procedure Mouse_Set_Wrap (Wrap : WrapMode);
   pragma Import (C, Mouse_Set_Wrap, "mouse_setwrap");
   

end SVGALibMouse;
