-------------------------------------------------------------------------------
--                                                                           --
--               Ada95 Bindings to Linux SVGA Library                        --
--                                                                           --
--                         Darren J Moffat                                   --
--                      moffatd@dcs.gla.ac.uk                                --
--                                                                           --
-- These bindings may be distributed under the same agreement as holds for   --
-- the current version of SVGALib.  With the additional condition that my    --
-- name must not be removed from any of the Ada source files.                --
--                                                                           --
-------------------------------------------------------------------------------
-- Last Modified: Wed Mar  1 21:44:55 1995
-- $RCSfile: modetest.adb,v $
-- $Revision: 1.1 $
-- $Author: djm $
--
-- $Log: modetest.adb,v $
-- Revision 1.1  1995/03/01  21:47:10  djm
-- Initial revision
--

 
with
  SVGALib,
--  SVGALibMouse,
  Text_IO;
use
  SVGALib, 
--  SVGALibMouse,
  Text_IO;


procedure ModeTest is
   package Int_IO is new Integer_IO (Integer); use Int_IO;
   package Vga_IO is new Enumeration_IO (VgaMode); use Vga_IO;
begin
   
   for M in VgaMode'First..VgaMode'Last loop
     If Has_Mode (M) then
	Set_Mode (M);

	Put ("Vga Mode: ");
	Put (M, Width => 20);
	Put (" Width: ");
	Put (Get_Xdim, Width => 5);
	Put (" Height: "); 
	Put (Get_Ydim, Width => 5);
	Put (" Colours: "); 
	Put (Get_Colours, Width => 5);
	New_Line ;

      else
 	Put ("Does Not Have Mode: ");
 	Put (M);
 	New_Line;
      end if;
   end loop;

end ModeTest;
